/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Color;
import org.apache.poi.sl.draw.DrawPaint;
import org.apache.poi.sl.usermodel.PaintStyle;
import org.apache.poi.sl.usermodel.StrokeStyle;
import org.apache.poi.sl.usermodel.TableCell;
import org.apache.poi.sl.usermodel.VerticalAlignment;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.usermodel.XSLFAutoShape;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineEndProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableCell;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableCellProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.STCompoundLine;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineCap;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndLength;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndType;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndWidth;
import org.openxmlformats.schemas.drawingml.x2006.main.STPenAlignment;
import org.openxmlformats.schemas.drawingml.x2006.main.STPresetLineDashVal;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAnchoringType;

public class XSLFTableCell
extends XSLFTextShape
implements TableCell<XSLFShape, XSLFTextParagraph> {
    private CTTableCellProperties _tcPr = null;

    XSLFTableCell(CTTableCell cell, XSLFSheet sheet) {
        super((XmlObject)cell, sheet);
    }

    @Override
    protected CTTextBody getTextBody(boolean create) {
        CTTableCell cell = (CTTableCell)this.getXmlObject();
        CTTextBody txBody = cell.getTxBody();
        if (txBody == null && create) {
            txBody = cell.addNewTxBody();
            XSLFAutoShape.initTextBody(txBody);
        }
        return txBody;
    }

    static CTTableCell prototype() {
        CTTableCell cell = CTTableCell.Factory.newInstance();
        CTTableCellProperties pr = cell.addNewTcPr();
        pr.addNewLnL().addNewNoFill();
        pr.addNewLnR().addNewNoFill();
        pr.addNewLnT().addNewNoFill();
        pr.addNewLnB().addNewNoFill();
        return cell;
    }

    protected CTTableCellProperties getCellProperties(boolean create) {
        if (this._tcPr == null) {
            CTTableCell cell = (CTTableCell)this.getXmlObject();
            this._tcPr = cell.getTcPr();
            if (this._tcPr == null && create) {
                this._tcPr = cell.addNewTcPr();
            }
        }
        return this._tcPr;
    }

    @Override
    public void setLeftInset(double margin) {
        CTTableCellProperties pr = this.getCellProperties(true);
        pr.setMarL(Units.toEMU((double)margin));
    }

    @Override
    public void setRightInset(double margin) {
        CTTableCellProperties pr = this.getCellProperties(true);
        pr.setMarR(Units.toEMU((double)margin));
    }

    @Override
    public void setTopInset(double margin) {
        CTTableCellProperties pr = this.getCellProperties(true);
        pr.setMarT(Units.toEMU((double)margin));
    }

    @Override
    public void setBottomInset(double margin) {
        CTTableCellProperties pr = this.getCellProperties(true);
        pr.setMarB(Units.toEMU((double)margin));
    }

    private CTLineProperties getCTLine(TableCell.BorderEdge edge, boolean create) {
        if (edge == null) {
            throw new IllegalArgumentException("BorderEdge needs to be specified.");
        }
        CTTableCellProperties pr = this.getCellProperties(create);
        if (pr == null) {
            return null;
        }
        switch (edge) {
            case bottom: {
                return pr.isSetLnB() ? pr.getLnB() : (create ? pr.addNewLnB() : null);
            }
            case left: {
                return pr.isSetLnL() ? pr.getLnL() : (create ? pr.addNewLnL() : null);
            }
            case top: {
                return pr.isSetLnT() ? pr.getLnT() : (create ? pr.addNewLnT() : null);
            }
            case right: {
                return pr.isSetLnR() ? pr.getLnR() : (create ? pr.addNewLnR() : null);
            }
        }
        return null;
    }

    public void removeBorder(TableCell.BorderEdge edge) {
        CTTableCellProperties pr = this.getCellProperties(false);
        if (pr == null) {
            return;
        }
        switch (edge) {
            case bottom: {
                if (!pr.isSetLnB()) break;
                pr.unsetLnB();
                break;
            }
            case left: {
                if (!pr.isSetLnL()) break;
                pr.unsetLnL();
                break;
            }
            case top: {
                if (!pr.isSetLnT()) break;
                pr.unsetLnT();
                break;
            }
            case right: {
                if (!pr.isSetLnR()) break;
                pr.unsetLnB();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public StrokeStyle getBorderStyle(final TableCell.BorderEdge edge) {
        final Double width = this.getBorderWidth(edge);
        return width == null ? null : new StrokeStyle(){

            public PaintStyle getPaint() {
                return DrawPaint.createSolidPaint((Color)XSLFTableCell.this.getBorderColor(edge));
            }

            public StrokeStyle.LineCap getLineCap() {
                return XSLFTableCell.this.getBorderCap(edge);
            }

            public StrokeStyle.LineDash getLineDash() {
                return XSLFTableCell.this.getBorderDash(edge);
            }

            public StrokeStyle.LineCompound getLineCompound() {
                return XSLFTableCell.this.getBorderCompound(edge);
            }

            public double getLineWidth() {
                return width;
            }
        };
    }

    public void setBorderStyle(TableCell.BorderEdge edge, StrokeStyle style) {
        StrokeStyle.LineDash dash;
        StrokeStyle.LineCompound compound;
        if (style == null) {
            throw new IllegalArgumentException("StrokeStyle needs to be specified.");
        }
        StrokeStyle.LineCap cap = style.getLineCap();
        if (cap != null) {
            this.setBorderCap(edge, cap);
        }
        if ((compound = style.getLineCompound()) != null) {
            this.setBorderCompound(edge, compound);
        }
        if ((dash = style.getLineDash()) != null) {
            this.setBorderDash(edge, dash);
        }
        double width = style.getLineWidth();
        this.setBorderWidth(edge, width);
    }

    public Double getBorderWidth(TableCell.BorderEdge edge) {
        CTLineProperties ln = this.getCTLine(edge, false);
        return ln == null || !ln.isSetW() ? null : Double.valueOf(Units.toPoints((long)ln.getW()));
    }

    public void setBorderWidth(TableCell.BorderEdge edge, double width) {
        CTLineProperties ln = this.getCTLine(edge, true);
        ln.setW(Units.toEMU((double)width));
    }

    private CTLineProperties setBorderDefaults(TableCell.BorderEdge edge) {
        CTLineProperties ln = this.getCTLine(edge, true);
        if (ln.isSetNoFill()) {
            ln.unsetNoFill();
        }
        if (!ln.isSetPrstDash()) {
            ln.addNewPrstDash().setVal(STPresetLineDashVal.SOLID);
        }
        if (!ln.isSetCmpd()) {
            ln.setCmpd(STCompoundLine.SNG);
        }
        if (!ln.isSetAlgn()) {
            ln.setAlgn(STPenAlignment.CTR);
        }
        if (!ln.isSetCap()) {
            ln.setCap(STLineCap.FLAT);
        }
        if (!ln.isSetRound()) {
            ln.addNewRound();
        }
        if (!ln.isSetHeadEnd()) {
            CTLineEndProperties hd = ln.addNewHeadEnd();
            hd.setType(STLineEndType.NONE);
            hd.setW(STLineEndWidth.MED);
            hd.setLen(STLineEndLength.MED);
        }
        if (!ln.isSetTailEnd()) {
            CTLineEndProperties tl = ln.addNewTailEnd();
            tl.setType(STLineEndType.NONE);
            tl.setW(STLineEndWidth.MED);
            tl.setLen(STLineEndLength.MED);
        }
        return ln;
    }

    public void setBorderColor(TableCell.BorderEdge edge, Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Colors need to be specified.");
        }
        CTLineProperties ln = this.setBorderDefaults(edge);
        CTSRgbColor rgb = CTSRgbColor.Factory.newInstance();
        rgb.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
        ln.addNewSolidFill().setSrgbClr(rgb);
    }

    public Color getBorderColor(TableCell.BorderEdge edge) {
        CTLineProperties ln = this.getCTLine(edge, false);
        if (ln == null || ln.isSetNoFill() || !ln.isSetSolidFill()) {
            return null;
        }
        CTSolidColorFillProperties fill = ln.getSolidFill();
        if (!fill.isSetSrgbClr()) {
            return null;
        }
        byte[] val = fill.getSrgbClr().getVal();
        return new Color(0xFF & val[0], 0xFF & val[1], 0xFF & val[2]);
    }

    public StrokeStyle.LineCompound getBorderCompound(TableCell.BorderEdge edge) {
        CTLineProperties ln = this.getCTLine(edge, false);
        if (ln == null || ln.isSetNoFill() || !ln.isSetSolidFill() || !ln.isSetCmpd()) {
            return null;
        }
        return StrokeStyle.LineCompound.fromOoxmlId((int)ln.getCmpd().intValue());
    }

    public void setBorderCompound(TableCell.BorderEdge edge, StrokeStyle.LineCompound compound) {
        if (compound == null) {
            throw new IllegalArgumentException("LineCompound need to be specified.");
        }
        CTLineProperties ln = this.setBorderDefaults(edge);
        ln.setCmpd(STCompoundLine.Enum.forInt((int)compound.ooxmlId));
    }

    public StrokeStyle.LineDash getBorderDash(TableCell.BorderEdge edge) {
        CTLineProperties ln = this.getCTLine(edge, false);
        if (ln == null || ln.isSetNoFill() || !ln.isSetSolidFill() || !ln.isSetPrstDash()) {
            return null;
        }
        return StrokeStyle.LineDash.fromOoxmlId((int)ln.getPrstDash().getVal().intValue());
    }

    public void setBorderDash(TableCell.BorderEdge edge, StrokeStyle.LineDash dash) {
        if (dash == null) {
            throw new IllegalArgumentException("LineDash need to be specified.");
        }
        CTLineProperties ln = this.setBorderDefaults(edge);
        ln.getPrstDash().setVal(STPresetLineDashVal.Enum.forInt((int)dash.ooxmlId));
    }

    public StrokeStyle.LineCap getBorderCap(TableCell.BorderEdge edge) {
        CTLineProperties ln = this.getCTLine(edge, false);
        if (ln == null || ln.isSetNoFill() || !ln.isSetSolidFill() || !ln.isSetCap()) {
            return null;
        }
        return StrokeStyle.LineCap.fromOoxmlId((int)ln.getCap().intValue());
    }

    public void setBorderCap(TableCell.BorderEdge edge, StrokeStyle.LineCap cap) {
        if (cap == null) {
            throw new IllegalArgumentException("LineCap need to be specified.");
        }
        CTLineProperties ln = this.setBorderDefaults(edge);
        ln.setCap(STLineCap.Enum.forInt((int)cap.ooxmlId));
    }

    @Override
    public void setFillColor(Color color) {
        CTTableCellProperties spPr = this.getCellProperties(true);
        if (color == null) {
            if (spPr.isSetSolidFill()) {
                spPr.unsetSolidFill();
            }
        } else {
            CTSolidColorFillProperties fill = spPr.isSetSolidFill() ? spPr.getSolidFill() : spPr.addNewSolidFill();
            CTSRgbColor rgb = CTSRgbColor.Factory.newInstance();
            rgb.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
            fill.setSrgbClr(rgb);
        }
    }

    @Override
    public Color getFillColor() {
        CTTableCellProperties spPr = this.getCellProperties(false);
        if (spPr == null || !spPr.isSetSolidFill()) {
            return null;
        }
        CTSolidColorFillProperties fill = spPr.getSolidFill();
        if (!fill.isSetSrgbClr()) {
            return null;
        }
        byte[] val = fill.getSrgbClr().getVal();
        return new Color(0xFF & val[0], 0xFF & val[1], 0xFF & val[2]);
    }

    void setGridSpan(int gridSpan_) {
        ((CTTableCell)this.getXmlObject()).setGridSpan(gridSpan_);
    }

    void setRowSpan(int rowSpan_) {
        ((CTTableCell)this.getXmlObject()).setRowSpan(rowSpan_);
    }

    void setHMerge(boolean merge_) {
        ((CTTableCell)this.getXmlObject()).setHMerge(merge_);
    }

    void setVMerge(boolean merge_) {
        ((CTTableCell)this.getXmlObject()).setVMerge(merge_);
    }

    @Override
    public void setVerticalAlignment(VerticalAlignment anchor) {
        CTTableCellProperties cellProps = this.getCellProperties(true);
        if (anchor == null) {
            if (cellProps.isSetAnchor()) {
                cellProps.unsetAnchor();
            }
        } else {
            cellProps.setAnchor(STTextAnchoringType.Enum.forInt((int)(anchor.ordinal() + 1)));
        }
    }

    @Override
    public VerticalAlignment getVerticalAlignment() {
        CTTableCellProperties cellProps = this.getCellProperties(false);
        VerticalAlignment align = VerticalAlignment.TOP;
        if (cellProps != null && cellProps.isSetAnchor()) {
            int ival = cellProps.getAnchor().intValue();
            align = VerticalAlignment.values()[ival - 1];
        }
        return align;
    }
}

