/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.ResetableExporterFilter;
import net.sf.jasperreports.engine.type.BandTypeEnum;

public class JROriginExporterFilter
implements ResetableExporterFilter {
    public static final String PROPERTY_EXCLUDE_ORIGIN_PREFIX = "exclude.origin.";
    private static final String KEEP_FIRST_PREFIX = "keep.first.";
    private static final String BAND_PREFIX = "band.";
    private static final String GROUP_PREFIX = "group.";
    private static final String REPORT_PREFIX = "report.";
    private Map<JROrigin, Boolean> originsToExclude = new HashMap<JROrigin, Boolean>();
    private Map<Integer, JRPrintElement> firstOccurrences = new HashMap<Integer, JRPrintElement>();
    private Map<JROrigin, Boolean> matchedOrigins = new HashMap<JROrigin, Boolean>();

    public void addOrigin(JROrigin origin) {
        this.addOrigin(origin, false);
    }

    public void addOrigin(JROrigin origin, boolean keepFirst) {
        this.originsToExclude.put(origin, keepFirst ? Boolean.TRUE : Boolean.FALSE);
    }

    public void removeOrigin(JROrigin origin) {
        this.originsToExclude.remove(origin);
    }

    @Override
    public void reset() {
        this.firstOccurrences = new HashMap<Integer, JRPrintElement>();
    }

    @Override
    public boolean isToExport(JRPrintElement element) {
        JROrigin origin = element.getOrigin();
        Boolean keepFirst = null;
        if (origin != null && (keepFirst = this.matchedOrigins.get(origin)) == null) {
            for (JROrigin originToExclude : this.originsToExclude.keySet()) {
                if (!this.match(originToExclude, origin)) continue;
                keepFirst = this.originsToExclude.get(originToExclude);
                this.matchedOrigins.put(origin, keepFirst);
                break;
            }
        }
        boolean originMatched = keepFirst != null;
        return !originMatched || keepFirst != false && this.isFirst(element);
    }

    public boolean match(JROrigin originToExclude, JROrigin origin) {
        String groupName1 = originToExclude.getGroupName();
        String reportName1 = originToExclude.getReportName();
        String groupName2 = origin.getGroupName();
        String reportName2 = origin.getReportName();
        return originToExclude.getBandTypeValue() == origin.getBandTypeValue() && ("*".equals(groupName1) && groupName2 != null || (groupName1 == null ? groupName2 == null : groupName2 != null && groupName1.equals(groupName2))) && ("*".equals(reportName1) && reportName2 != null || (reportName1 == null ? reportName2 == null : reportName2 != null && reportName1.equals(reportName2)));
    }

    private boolean isFirst(JRPrintElement element) {
        int elementId = element.getSourceElementId();
        if (elementId == 0) {
            return true;
        }
        JRPrintElement firstElement = this.firstOccurrences.get(elementId);
        if (firstElement == null || firstElement == element) {
            this.firstOccurrences.put(elementId, element);
            return true;
        }
        return false;
    }

    public static JROriginExporterFilter getFilter(JasperReportsContext jasperReportsContext, JRPropertiesMap propertiesMap, String originFilterPrefix) {
        JROriginExporterFilter filter = null;
        filter = JROriginExporterFilter.addOriginsToFilter(jasperReportsContext, filter, propertiesMap, originFilterPrefix, false);
        filter = JROriginExporterFilter.addOriginsToFilter(jasperReportsContext, filter, propertiesMap, originFilterPrefix + KEEP_FIRST_PREFIX, true);
        return filter;
    }

    public static JROriginExporterFilter getFilter(JRPropertiesMap propertiesMap, String originFilterPrefix) {
        return JROriginExporterFilter.getFilter(DefaultJasperReportsContext.getInstance(), propertiesMap, originFilterPrefix);
    }

    private static JROriginExporterFilter addOriginsToFilter(JasperReportsContext jasperReportsContext, JROriginExporterFilter filter, JRPropertiesMap propertiesMap, String originFilterPrefix, boolean keepFirst) {
        JRPropertiesUtil propUtil = JRPropertiesUtil.getInstance(jasperReportsContext);
        List<JRPropertiesUtil.PropertySuffix> properties = propUtil.getProperties(originFilterPrefix + BAND_PREFIX);
        properties.addAll(JRPropertiesUtil.getProperties(propertiesMap, originFilterPrefix + BAND_PREFIX));
        if (!properties.isEmpty()) {
            filter = filter == null ? new JROriginExporterFilter() : filter;
            for (JRPropertiesUtil.PropertySuffix propertySuffix : properties) {
                String suffix = propertySuffix.getSuffix();
                BandTypeEnum bandType = BandTypeEnum.getByName(propUtil.getProperty(propertiesMap, propertySuffix.getKey()));
                if (bandType == null) continue;
                filter.addOrigin(new JROrigin(propUtil.getProperty(propertiesMap, originFilterPrefix + REPORT_PREFIX + suffix), propUtil.getProperty(propertiesMap, originFilterPrefix + GROUP_PREFIX + suffix), bandType), keepFirst);
            }
        }
        return filter;
    }
}

