
package ru.corteos;

import java.io.Serializable;
import org.joda.time.DateTime;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://corteos.ru" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrchestratedPersonContainer">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="id_Person" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OrchestratedPersonAccount" name="Account" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ArrayOfOrchestratedPersonDocument" name="Documents" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ArrayOfOrchestratedPersonMileCard" name="MileCards" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ArrayOfOrchestratedPersonContact" name="Contacts" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ArrayOfOrchestratedPersonMetaCode" name="MetaCodes" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ArrayOfOrchestratedPersonTravelPolicy" name="PersonalPolicies" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OrchestratedPersonOptions" name="Options" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:int" use="required" name="id_Group"/>
 *   &lt;xs:attribute type="xs:string" name="LastName"/>
 *   &lt;xs:attribute type="xs:string" name="FirstName"/>
 *   &lt;xs:attribute type="xs:string" name="MiddleName"/>
 *   &lt;xs:attribute type="xs:string" name="LastNameLatin"/>
 *   &lt;xs:attribute type="xs:string" name="FirstNameLatin"/>
 *   &lt;xs:attribute type="xs:string" name="MiddleNameLatin"/>
 *   &lt;xs:attribute type="xs:dateTime" use="required" name="BirthDate"/>
 *   &lt;xs:attribute type="xs:string" name="CitizenshipAlpha2Code"/>
 *   &lt;xs:attribute type="xs:int" use="required" name="id_Organization"/>
 *   &lt;xs:attribute type="xs:boolean" use="required" name="Male"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrchestratedPersonContainer implements Serializable
{
    private String idPerson;
    private OrchestratedPersonAccount account;
    private ArrayOfOrchestratedPersonDocument documents;
    private ArrayOfOrchestratedPersonMileCard mileCards;
    private ArrayOfOrchestratedPersonContact contacts;
    private ArrayOfOrchestratedPersonMetaCode metaCodes;
    private ArrayOfOrchestratedPersonTravelPolicy personalPolicies;
    private OrchestratedPersonOptions options;
    private int idGroup;
    private String lastName;
    private String firstName;
    private String middleName;
    private String lastNameLatin;
    private String firstNameLatin;
    private String middleNameLatin;
    private DateTime birthDate;
    private String citizenshipAlpha2Code;
    private int idOrganization;
    private boolean male;

    /** 
     * Get the 'id_Person' element value.
     * 
     * @return value
     */
    public String getIdPerson() {
        return idPerson;
    }

    /** 
     * Set the 'id_Person' element value.
     * 
     * @param idPerson
     */
    public void setIdPerson(String idPerson) {
        this.idPerson = idPerson;
    }

    /** 
     * Get the 'Account' element value.
     * 
     * @return value
     */
    public OrchestratedPersonAccount getAccount() {
        return account;
    }

    /** 
     * Set the 'Account' element value.
     * 
     * @param account
     */
    public void setAccount(OrchestratedPersonAccount account) {
        this.account = account;
    }

    /** 
     * Get the 'Documents' element value.
     * 
     * @return value
     */
    public ArrayOfOrchestratedPersonDocument getDocuments() {
        return documents;
    }

    /** 
     * Set the 'Documents' element value.
     * 
     * @param documents
     */
    public void setDocuments(ArrayOfOrchestratedPersonDocument documents) {
        this.documents = documents;
    }

    /** 
     * Get the 'MileCards' element value.
     * 
     * @return value
     */
    public ArrayOfOrchestratedPersonMileCard getMileCards() {
        return mileCards;
    }

    /** 
     * Set the 'MileCards' element value.
     * 
     * @param mileCards
     */
    public void setMileCards(ArrayOfOrchestratedPersonMileCard mileCards) {
        this.mileCards = mileCards;
    }

    /** 
     * Get the 'Contacts' element value.
     * 
     * @return value
     */
    public ArrayOfOrchestratedPersonContact getContacts() {
        return contacts;
    }

    /** 
     * Set the 'Contacts' element value.
     * 
     * @param contacts
     */
    public void setContacts(ArrayOfOrchestratedPersonContact contacts) {
        this.contacts = contacts;
    }

    /** 
     * Get the 'MetaCodes' element value.
     * 
     * @return value
     */
    public ArrayOfOrchestratedPersonMetaCode getMetaCodes() {
        return metaCodes;
    }

    /** 
     * Set the 'MetaCodes' element value.
     * 
     * @param metaCodes
     */
    public void setMetaCodes(ArrayOfOrchestratedPersonMetaCode metaCodes) {
        this.metaCodes = metaCodes;
    }

    /** 
     * Get the 'PersonalPolicies' element value.
     * 
     * @return value
     */
    public ArrayOfOrchestratedPersonTravelPolicy getPersonalPolicies() {
        return personalPolicies;
    }

    /** 
     * Set the 'PersonalPolicies' element value.
     * 
     * @param personalPolicies
     */
    public void setPersonalPolicies(
            ArrayOfOrchestratedPersonTravelPolicy personalPolicies) {
        this.personalPolicies = personalPolicies;
    }

    /** 
     * Get the 'Options' element value.
     * 
     * @return value
     */
    public OrchestratedPersonOptions getOptions() {
        return options;
    }

    /** 
     * Set the 'Options' element value.
     * 
     * @param options
     */
    public void setOptions(OrchestratedPersonOptions options) {
        this.options = options;
    }

    /** 
     * Get the 'id_Group' attribute value.
     * 
     * @return value
     */
    public int getIdGroup() {
        return idGroup;
    }

    /** 
     * Set the 'id_Group' attribute value.
     * 
     * @param idGroup
     */
    public void setIdGroup(int idGroup) {
        this.idGroup = idGroup;
    }

    /** 
     * Get the 'LastName' attribute value.
     * 
     * @return value
     */
    public String getLastName() {
        return lastName;
    }

    /** 
     * Set the 'LastName' attribute value.
     * 
     * @param lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /** 
     * Get the 'FirstName' attribute value.
     * 
     * @return value
     */
    public String getFirstName() {
        return firstName;
    }

    /** 
     * Set the 'FirstName' attribute value.
     * 
     * @param firstName
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /** 
     * Get the 'MiddleName' attribute value.
     * 
     * @return value
     */
    public String getMiddleName() {
        return middleName;
    }

    /** 
     * Set the 'MiddleName' attribute value.
     * 
     * @param middleName
     */
    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    /** 
     * Get the 'LastNameLatin' attribute value.
     * 
     * @return value
     */
    public String getLastNameLatin() {
        return lastNameLatin;
    }

    /** 
     * Set the 'LastNameLatin' attribute value.
     * 
     * @param lastNameLatin
     */
    public void setLastNameLatin(String lastNameLatin) {
        this.lastNameLatin = lastNameLatin;
    }

    /** 
     * Get the 'FirstNameLatin' attribute value.
     * 
     * @return value
     */
    public String getFirstNameLatin() {
        return firstNameLatin;
    }

    /** 
     * Set the 'FirstNameLatin' attribute value.
     * 
     * @param firstNameLatin
     */
    public void setFirstNameLatin(String firstNameLatin) {
        this.firstNameLatin = firstNameLatin;
    }

    /** 
     * Get the 'MiddleNameLatin' attribute value.
     * 
     * @return value
     */
    public String getMiddleNameLatin() {
        return middleNameLatin;
    }

    /** 
     * Set the 'MiddleNameLatin' attribute value.
     * 
     * @param middleNameLatin
     */
    public void setMiddleNameLatin(String middleNameLatin) {
        this.middleNameLatin = middleNameLatin;
    }

    /** 
     * Get the 'BirthDate' attribute value.
     * 
     * @return value
     */
    public DateTime getBirthDate() {
        return birthDate;
    }

    /** 
     * Set the 'BirthDate' attribute value.
     * 
     * @param birthDate
     */
    public void setBirthDate(DateTime birthDate) {
        this.birthDate = birthDate;
    }

    /** 
     * Get the 'CitizenshipAlpha2Code' attribute value.
     * 
     * @return value
     */
    public String getCitizenshipAlpha2Code() {
        return citizenshipAlpha2Code;
    }

    /** 
     * Set the 'CitizenshipAlpha2Code' attribute value.
     * 
     * @param citizenshipAlpha2Code
     */
    public void setCitizenshipAlpha2Code(String citizenshipAlpha2Code) {
        this.citizenshipAlpha2Code = citizenshipAlpha2Code;
    }

    /** 
     * Get the 'id_Organization' attribute value.
     * 
     * @return value
     */
    public int getIdOrganization() {
        return idOrganization;
    }

    /** 
     * Set the 'id_Organization' attribute value.
     * 
     * @param idOrganization
     */
    public void setIdOrganization(int idOrganization) {
        this.idOrganization = idOrganization;
    }

    /** 
     * Get the 'Male' attribute value.
     * 
     * @return value
     */
    public boolean isMale() {
        return male;
    }

    /** 
     * Set the 'Male' attribute value.
     * 
     * @param male
     */
    public void setMale(boolean male) {
        this.male = male;
    }
}
