
package ru.corteos;

import java.io.Serializable;
import org.joda.time.DateTime;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://corteos.ru" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StableComplexReserve">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" name="id_ComplexReserve" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="LocationName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:double" name="Latitude" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:double" name="Longitude" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OuterId" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:StableClient" name="Creator" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ArrayOfStableCode" name="Codes" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ArrayOfStablePassenger" name="Passengers" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ArrayOfStableSimpleReserve" name="ActualOrders" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ArrayOfStableSimpleReserve" name="CanceledOrders" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="ComplexReserveStateName"/>
 *   &lt;xs:attribute type="xs:int" use="required" name="id_ComplexReserveState"/>
 *   &lt;xs:attribute type="xs:dateTime" use="required" name="DateCreate"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class StableComplexReserve implements Serializable
{
    private int idComplexReserve;
    private String name;
    private String locationName;
    private Double latitude;
    private Double longitude;
    private String outerId;
    private StableClient creator;
    private ArrayOfStableCode codes;
    private ArrayOfStablePassenger passengers;
    private ArrayOfStableSimpleReserve actualOrders;
    private ArrayOfStableSimpleReserve canceledOrders;
    private String complexReserveStateName;
    private int idComplexReserveState;
    private DateTime dateCreate;

    /** 
     * Get the 'id_ComplexReserve' element value.
     * 
     * @return value
     */
    public int getIdComplexReserve() {
        return idComplexReserve;
    }

    /** 
     * Set the 'id_ComplexReserve' element value.
     * 
     * @param idComplexReserve
     */
    public void setIdComplexReserve(int idComplexReserve) {
        this.idComplexReserve = idComplexReserve;
    }

    /** 
     * Get the 'Name' element value.
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value.
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'LocationName' element value.
     * 
     * @return value
     */
    public String getLocationName() {
        return locationName;
    }

    /** 
     * Set the 'LocationName' element value.
     * 
     * @param locationName
     */
    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    /** 
     * Get the 'Latitude' element value.
     * 
     * @return value
     */
    public Double getLatitude() {
        return latitude;
    }

    /** 
     * Set the 'Latitude' element value.
     * 
     * @param latitude
     */
    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    /** 
     * Get the 'Longitude' element value.
     * 
     * @return value
     */
    public Double getLongitude() {
        return longitude;
    }

    /** 
     * Set the 'Longitude' element value.
     * 
     * @param longitude
     */
    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    /** 
     * Get the 'OuterId' element value.
     * 
     * @return value
     */
    public String getOuterId() {
        return outerId;
    }

    /** 
     * Set the 'OuterId' element value.
     * 
     * @param outerId
     */
    public void setOuterId(String outerId) {
        this.outerId = outerId;
    }

    /** 
     * Get the 'Creator' element value.
     * 
     * @return value
     */
    public StableClient getCreator() {
        return creator;
    }

    /** 
     * Set the 'Creator' element value.
     * 
     * @param creator
     */
    public void setCreator(StableClient creator) {
        this.creator = creator;
    }

    /** 
     * Get the 'Codes' element value.
     * 
     * @return value
     */
    public ArrayOfStableCode getCodes() {
        return codes;
    }

    /** 
     * Set the 'Codes' element value.
     * 
     * @param codes
     */
    public void setCodes(ArrayOfStableCode codes) {
        this.codes = codes;
    }

    /** 
     * Get the 'Passengers' element value.
     * 
     * @return value
     */
    public ArrayOfStablePassenger getPassengers() {
        return passengers;
    }

    /** 
     * Set the 'Passengers' element value.
     * 
     * @param passengers
     */
    public void setPassengers(ArrayOfStablePassenger passengers) {
        this.passengers = passengers;
    }

    /** 
     * Get the 'ActualOrders' element value.
     * 
     * @return value
     */
    public ArrayOfStableSimpleReserve getActualOrders() {
        return actualOrders;
    }

    /** 
     * Set the 'ActualOrders' element value.
     * 
     * @param actualOrders
     */
    public void setActualOrders(ArrayOfStableSimpleReserve actualOrders) {
        this.actualOrders = actualOrders;
    }

    /** 
     * Get the 'CanceledOrders' element value.
     * 
     * @return value
     */
    public ArrayOfStableSimpleReserve getCanceledOrders() {
        return canceledOrders;
    }

    /** 
     * Set the 'CanceledOrders' element value.
     * 
     * @param canceledOrders
     */
    public void setCanceledOrders(ArrayOfStableSimpleReserve canceledOrders) {
        this.canceledOrders = canceledOrders;
    }

    /** 
     * Get the 'ComplexReserveStateName' attribute value.
     * 
     * @return value
     */
    public String getComplexReserveStateName() {
        return complexReserveStateName;
    }

    /** 
     * Set the 'ComplexReserveStateName' attribute value.
     * 
     * @param complexReserveStateName
     */
    public void setComplexReserveStateName(String complexReserveStateName) {
        this.complexReserveStateName = complexReserveStateName;
    }

    /** 
     * Get the 'id_ComplexReserveState' attribute value.
     * 
     * @return value
     */
    public int getIdComplexReserveState() {
        return idComplexReserveState;
    }

    /** 
     * Set the 'id_ComplexReserveState' attribute value.
     * 
     * @param idComplexReserveState
     */
    public void setIdComplexReserveState(int idComplexReserveState) {
        this.idComplexReserveState = idComplexReserveState;
    }

    /** 
     * Get the 'DateCreate' attribute value.
     * 
     * @return value
     */
    public DateTime getDateCreate() {
        return dateCreate;
    }

    /** 
     * Set the 'DateCreate' attribute value.
     * 
     * @param dateCreate
     */
    public void setDateCreate(DateTime dateCreate) {
        this.dateCreate = dateCreate;
    }
}
