
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * AIRCRAFT CORE representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AircraftCoreType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="AircraftCode"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="ChangeOfGaugeInd"/>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class AircraftCoreType implements Serializable
{
    private AircraftCodeType aircraftCode;
    private Boolean changeOfGaugeInd;
    private String refs;

    /** 
     * Get the 'AircraftCode' element value. Equipment Code. Example: 737

    Encoding Scheme: IATA/ A4A Equipment Code
     * 
     * @return value
     */
    public AircraftCodeType getAircraftCode() {
        return aircraftCode;
    }

    /** 
     * Set the 'AircraftCode' element value. Equipment Code. Example: 737

    Encoding Scheme: IATA/ A4A Equipment Code
     * 
     * @param aircraftCode
     */
    public void setAircraftCode(AircraftCodeType aircraftCode) {
        this.aircraftCode = aircraftCode;
    }

    /** 
     * Get the 'ChangeOfGaugeInd' attribute value. When TUE, this aircraft equipment information is associated with a flight change of gauge.
     * 
     * @return value
     */
    public Boolean getChangeOfGaugeInd() {
        return changeOfGaugeInd;
    }

    /** 
     * Set the 'ChangeOfGaugeInd' attribute value. When TUE, this aircraft equipment information is associated with a flight change of gauge.
     * 
     * @param changeOfGaugeInd
     */
    public void setChangeOfGaugeInd(Boolean changeOfGaugeInd) {
        this.changeOfGaugeInd = changeOfGaugeInd;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
