
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for Aggregated Optional Service Offer Information for One Airline.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirlineOffersSnapshotType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="PassengerQuantity"/>
 *     &lt;xs:element ref="AssociatedPassenger" minOccurs="0"/>
 *     &lt;xs:element name="SubTotal" minOccurs="0">
 *       &lt;!-- Reference to inner class SubTotal -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Highest" minOccurs="0">
 *       &lt;!-- Reference to inner class Highest -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Lowest" minOccurs="0">
 *       &lt;!-- Reference to inner class Lowest -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="MatchedOfferQuantity" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class AirlineOffersSnapshotType implements Serializable
{
    private String passengerQuantity;
    private PassengerInfoAssocType associatedPassenger;
    private SubTotal subTotal;
    private Highest highest;
    private Lowest lowest;
    private String matchedOfferQuantity;
    private String refs;

    /** 
     * Get the 'PassengerQuantity' element value. Total number of Passengers (of the same passenger type) included in this offer.
     * 
     * @return value
     */
    public String getPassengerQuantity() {
        return passengerQuantity;
    }

    /** 
     * Set the 'PassengerQuantity' element value. Total number of Passengers (of the same passenger type) included in this offer.
     * 
     * @param passengerQuantity
     */
    public void setPassengerQuantity(String passengerQuantity) {
        this.passengerQuantity = passengerQuantity;
    }

    /** 
     * Get the 'AssociatedPassenger' element value.
     * 
     * @return value
     */
    public PassengerInfoAssocType getAssociatedPassenger() {
        return associatedPassenger;
    }

    /** 
     * Set the 'AssociatedPassenger' element value.
     * 
     * @param associatedPassenger
     */
    public void setAssociatedPassenger(
            PassengerInfoAssocType associatedPassenger) {
        this.associatedPassenger = associatedPassenger;
    }

    /** 
     * Get the 'SubTotal' element value.
     * 
     * @return value
     */
    public SubTotal getSubTotal() {
        return subTotal;
    }

    /** 
     * Set the 'SubTotal' element value.
     * 
     * @param subTotal
     */
    public void setSubTotal(SubTotal subTotal) {
        this.subTotal = subTotal;
    }

    /** 
     * Get the 'Highest' element value.
     * 
     * @return value
     */
    public Highest getHighest() {
        return highest;
    }

    /** 
     * Set the 'Highest' element value.
     * 
     * @param highest
     */
    public void setHighest(Highest highest) {
        this.highest = highest;
    }

    /** 
     * Get the 'Lowest' element value.
     * 
     * @return value
     */
    public Lowest getLowest() {
        return lowest;
    }

    /** 
     * Set the 'Lowest' element value.
     * 
     * @param lowest
     */
    public void setLowest(Lowest lowest) {
        this.lowest = lowest;
    }

    /** 
     * Get the 'MatchedOfferQuantity' element value. Total Quantity of Offers that Matched search criteria. Example: 3

    Note: This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of this capability is not dictated by this specification. 
     * 
     * @return value
     */
    public String getMatchedOfferQuantity() {
        return matchedOfferQuantity;
    }

    /** 
     * Set the 'MatchedOfferQuantity' element value. Total Quantity of Offers that Matched search criteria. Example: 3

    Note: This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of this capability is not dictated by this specification. 
     * 
     * @param matchedOfferQuantity
     */
    public void setMatchedOfferQuantity(String matchedOfferQuantity) {
        this.matchedOfferQuantity = matchedOfferQuantity;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Sub-totaled Price for all Travelers (of all types) and all Offer Item(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SubTotal" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="SimpleCurrencyPrice"/>
     *       &lt;xs:element ref="EncodedCurrencyPrice"/>
     *       &lt;xs:element ref="DetailCurrencyPrice"/>
     *       &lt;xs:element ref="CombinationPricing"/>
     *       &lt;xs:element ref="AwardPricing"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class SubTotal implements Serializable
    {
        private SimpleCurrencyPrice simpleCurrencyPrice;
        private EncodedCurrencyPrice encodedCurrencyPrice;
        private DetailCurrencyPriceType detailCurrencyPrice;
        private CombinationPriceType combinationPricing;
        private AwardPriceUnitType awardPricing;
        private String refs;

        /** 
         * Get the 'SimpleCurrencyPrice' element value.
         * 
         * @return value
         */
        public SimpleCurrencyPrice getSimpleCurrencyPrice() {
            return simpleCurrencyPrice;
        }

        /** 
         * Set the 'SimpleCurrencyPrice' element value.
         * 
         * @param simpleCurrencyPrice
         */
        public void setSimpleCurrencyPrice(
                SimpleCurrencyPrice simpleCurrencyPrice) {
            this.simpleCurrencyPrice = simpleCurrencyPrice;
        }

        /** 
         * Get the 'EncodedCurrencyPrice' element value.
         * 
         * @return value
         */
        public EncodedCurrencyPrice getEncodedCurrencyPrice() {
            return encodedCurrencyPrice;
        }

        /** 
         * Set the 'EncodedCurrencyPrice' element value.
         * 
         * @param encodedCurrencyPrice
         */
        public void setEncodedCurrencyPrice(
                EncodedCurrencyPrice encodedCurrencyPrice) {
            this.encodedCurrencyPrice = encodedCurrencyPrice;
        }

        /** 
         * Get the 'DetailCurrencyPrice' element value.
         * 
         * @return value
         */
        public DetailCurrencyPriceType getDetailCurrencyPrice() {
            return detailCurrencyPrice;
        }

        /** 
         * Set the 'DetailCurrencyPrice' element value.
         * 
         * @param detailCurrencyPrice
         */
        public void setDetailCurrencyPrice(
                DetailCurrencyPriceType detailCurrencyPrice) {
            this.detailCurrencyPrice = detailCurrencyPrice;
        }

        /** 
         * Get the 'CombinationPricing' element value.
         * 
         * @return value
         */
        public CombinationPriceType getCombinationPricing() {
            return combinationPricing;
        }

        /** 
         * Set the 'CombinationPricing' element value.
         * 
         * @param combinationPricing
         */
        public void setCombinationPricing(
                CombinationPriceType combinationPricing) {
            this.combinationPricing = combinationPricing;
        }

        /** 
         * Get the 'AwardPricing' element value.
         * 
         * @return value
         */
        public AwardPriceUnitType getAwardPricing() {
            return awardPricing;
        }

        /** 
         * Set the 'AwardPricing' element value.
         * 
         * @param awardPricing
         */
        public void setAwardPricing(AwardPriceUnitType awardPricing) {
            this.awardPricing = awardPricing;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
    /** 
     * Highest Price for all Travelers (of all types) and all Offer Item(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Highest" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="EncodedCurrencyPrice"/>
     *       &lt;xs:element ref="AwardPricing"/>
     *     &lt;/xs:choice>
     *     &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Highest implements Serializable
    {
        private int choiceSelect = -1;
        private static final int ENCODED_CURRENCY_PRICE_CHOICE = 0;
        private static final int AWARD_PRICING_CHOICE = 1;
        private EncodedCurrencyPrice encodedCurrencyPrice;
        private AwardPriceUnitType awardPricing;
        private String refs;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if EncodedCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifEncodedCurrencyPrice() {
            return choiceSelect == ENCODED_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'EncodedCurrencyPrice' element value.
         * 
         * @return value
         */
        public EncodedCurrencyPrice getEncodedCurrencyPrice() {
            return encodedCurrencyPrice;
        }

        /** 
         * Set the 'EncodedCurrencyPrice' element value.
         * 
         * @param encodedCurrencyPrice
         */
        public void setEncodedCurrencyPrice(
                EncodedCurrencyPrice encodedCurrencyPrice) {
            setChoiceSelect(ENCODED_CURRENCY_PRICE_CHOICE);
            this.encodedCurrencyPrice = encodedCurrencyPrice;
        }

        /** 
         * Check if AwardPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAwardPricing() {
            return choiceSelect == AWARD_PRICING_CHOICE;
        }

        /** 
         * Get the 'AwardPricing' element value.
         * 
         * @return value
         */
        public AwardPriceUnitType getAwardPricing() {
            return awardPricing;
        }

        /** 
         * Set the 'AwardPricing' element value.
         * 
         * @param awardPricing
         */
        public void setAwardPricing(AwardPriceUnitType awardPricing) {
            setChoiceSelect(AWARD_PRICING_CHOICE);
            this.awardPricing = awardPricing;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
    /** 
     * Lowest Price for all Travelers (of all types) and all Offer Item(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Lowest" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="EncodedCurrencyPrice"/>
     *       &lt;xs:element ref="AwardPricing"/>
     *     &lt;/xs:choice>
     *     &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Lowest implements Serializable
    {
        private int choiceSelect = -1;
        private static final int ENCODED_CURRENCY_PRICE_CHOICE = 0;
        private static final int AWARD_PRICING_CHOICE = 1;
        private EncodedCurrencyPrice encodedCurrencyPrice;
        private AwardPriceUnitType awardPricing;
        private String refs;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if EncodedCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifEncodedCurrencyPrice() {
            return choiceSelect == ENCODED_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'EncodedCurrencyPrice' element value.
         * 
         * @return value
         */
        public EncodedCurrencyPrice getEncodedCurrencyPrice() {
            return encodedCurrencyPrice;
        }

        /** 
         * Set the 'EncodedCurrencyPrice' element value.
         * 
         * @param encodedCurrencyPrice
         */
        public void setEncodedCurrencyPrice(
                EncodedCurrencyPrice encodedCurrencyPrice) {
            setChoiceSelect(ENCODED_CURRENCY_PRICE_CHOICE);
            this.encodedCurrencyPrice = encodedCurrencyPrice;
        }

        /** 
         * Check if AwardPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAwardPricing() {
            return choiceSelect == AWARD_PRICING_CHOICE;
        }

        /** 
         * Get the 'AwardPricing' element value.
         * 
         * @return value
         */
        public AwardPriceUnitType getAwardPricing() {
            return awardPricing;
        }

        /** 
         * Set the 'AwardPricing' element value.
         * 
         * @param awardPricing
         */
        public void setAwardPricing(AwardPriceUnitType awardPricing) {
            setChoiceSelect(AWARD_PRICING_CHOICE);
            this.awardPricing = awardPricing;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
