
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * AIRLINE means: an enterprise operating aircraft for commercial purposes which (i) performs scheduled or  non-scheduled air transport services, or both, which are available to the public for carriage of passengers, mail and/or cargo and (ii) is certified for such purposes by the civil aviation authority of the state in which it is established.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirlineTypeAIDM">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AirlineName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AirlineDesignator" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirlineTypeAIDM implements Serializable
{
    private String airlineName;
    private String airlineDesignator;

    /** 
     * Get the 'AirlineName' element value. Issuing Airline Name. Example: British Airways
     * 
     * @return value
     */
    public String getAirlineName() {
        return airlineName;
    }

    /** 
     * Set the 'AirlineName' element value. Issuing Airline Name. Example: British Airways
     * 
     * @param airlineName
     */
    public void setAirlineName(String airlineName) {
        this.airlineName = airlineName;
    }

    /** 
     * Get the 'AirlineDesignator' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.  Refer to IATA Airline Coding Directory, Section 3.
     * 
     * @return value
     */
    public String getAirlineDesignator() {
        return airlineDesignator;
    }

    /** 
     * Set the 'AirlineDesignator' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.  Refer to IATA Airline Coding Directory, Section 3.
     * 
     * @param airlineDesignator
     */
    public void setAirlineDesignator(String airlineDesignator) {
        this.airlineDesignator = airlineDesignator;
    }
}
