
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Cabin type. Examples: First Class, Business Class

 Encoding Scheme: PADIS codeset element 9873 - Cabin Class of Service
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CabinType">
 *   &lt;xs:complexType>
 *     &lt;xs:complexContent>
 *       &lt;xs:extension base="CodesetType">
 *         &lt;xs:sequence>
 *           &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *           &lt;xs:element ref="OriginDestinationReferences" minOccurs="0" maxOccurs="unbounded"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:extension>
 *     &lt;/xs:complexContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class CabinType extends CodesetType implements Serializable
{
    private String name;
    private List<OriginDestinationReferences> originDestinationReferenceList = new ArrayList<OriginDestinationReferences>();

    /** 
     * Get the 'Name' element value. Cabin class marketing name. Example: Premium Economy
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Cabin class marketing name. Example: Premium Economy
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the list of 'OriginDestinationReferences' element items.
     * 
     * @return list
     */
    public List<OriginDestinationReferences> getOriginDestinationReferenceList() {
        return originDestinationReferenceList;
    }

    /** 
     * Set the list of 'OriginDestinationReferences' element items.
     * 
     * @param list
     */
    public void setOriginDestinationReferenceList(
            List<OriginDestinationReferences> list) {
        originDestinationReferenceList = list;
    }
}
