
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for Credit Card Qualifier.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CardQualifierType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Type"/>
 *     &lt;xs:element type="xs:string" name="IIN_Number" minOccurs="0"/>
 *     &lt;xs:element type="CurrencyAmountOptType" name="Amount" minOccurs="0"/>
 *     &lt;xs:element ref="CurrCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 *   &lt;xs:attribute type="xs:boolean" name="IsPercentInd"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class CardQualifierType implements Serializable
{
    private String type;
    private String IINNumber;
    private CurrencyAmountOptType amount;
    private CurrCode currCode;
    private String refs;
    private Boolean isPercentInd;

    /** 
     * Get the 'Type' element value. The two letter payment card type. Examples: MC, VI
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. The two letter payment card type. Examples: MC, VI
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'IIN_Number' element value. Payment card IIN/ BIN number. Example: 401123

    Note: This is the first 6 digits of a credit card number known as the Issuer Identification Number (IIN), previously known as bank identification number (BIN), that identifies the institution that issued the card to the card holder.
     * 
     * @return value
     */
    public String getIINNumber() {
        return IINNumber;
    }

    /** 
     * Set the 'IIN_Number' element value. Payment card IIN/ BIN number. Example: 401123

    Note: This is the first 6 digits of a credit card number known as the Issuer Identification Number (IIN), previously known as bank identification number (BIN), that identifies the institution that issued the card to the card holder.
     * 
     * @param IINNumber
     */
    public void setIINNumber(String IINNumber) {
        this.IINNumber = IINNumber;
    }

    /** 
     * Get the 'Amount' element value.
     * 
     * @return value
     */
    public CurrencyAmountOptType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value.
     * 
     * @param amount
     */
    public void setAmount(CurrencyAmountOptType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'CurrCode' element value.
     * 
     * @return value
     */
    public CurrCode getCurrCode() {
        return currCode;
    }

    /** 
     * Set the 'CurrCode' element value.
     * 
     * @param currCode
     */
    public void setCurrCode(CurrCode currCode) {
        this.currCode = currCode;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    /** 
     * Get the 'IsPercentInd' attribute value. If True, the amount value represents a percentage.
     * 
     * @return value
     */
    public Boolean getIsPercentInd() {
        return isPercentInd;
    }

    /** 
     * Set the 'IsPercentInd' attribute value. If True, the amount value represents a percentage.
     * 
     * @param isPercentInd
     */
    public void setIsPercentInd(Boolean isPercentInd) {
        this.isPercentInd = isPercentInd;
    }
}
