
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Contact(s).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Contacts">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Contact" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class Contact -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Contacts implements Serializable
{
    private List<Contact> contactList = new ArrayList<Contact>();

    /** 
     * Get the list of 'Contact' element items.
     * 
     * @return list
     */
    public List<Contact> getContactList() {
        return contactList;
    }

    /** 
     * Set the list of 'Contact' element items.
     * 
     * @param list
     */
    public void setContactList(List<Contact> list) {
        contactList = list;
    }
    /** 
     * Contact detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Contact" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="AddressContact" minOccurs="0"/>
     *       &lt;xs:element ref="EmailContact" minOccurs="0"/>
     *       &lt;xs:element ref="OtherContactMethod" minOccurs="0"/>
     *       &lt;xs:element ref="PhoneContact" minOccurs="0"/>
     *       &lt;xs:element name="Name" minOccurs="0">
     *         &lt;!-- Reference to inner class Name -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:anySimpleType" name="ContactType"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Contact implements Serializable
    {
        private AddressContact addressContact;
        private EmailType emailContact;
        private OtherContactMethodType otherContactMethod;
        private PhoneContact phoneContact;
        private Name name;
        private String contactType;

        /** 
         * Get the 'AddressContact' element value.
         * 
         * @return value
         */
        public AddressContact getAddressContact() {
            return addressContact;
        }

        /** 
         * Set the 'AddressContact' element value.
         * 
         * @param addressContact
         */
        public void setAddressContact(AddressContact addressContact) {
            this.addressContact = addressContact;
        }

        /** 
         * Get the 'EmailContact' element value. Email address details, including application (I.e. home, business, etc.).
         * 
         * @return value
         */
        public EmailType getEmailContact() {
            return emailContact;
        }

        /** 
         * Set the 'EmailContact' element value. Email address details, including application (I.e. home, business, etc.).
         * 
         * @param emailContact
         */
        public void setEmailContact(EmailType emailContact) {
            this.emailContact = emailContact;
        }

        /** 
         * Get the 'OtherContactMethod' element value.
         * 
         * @return value
         */
        public OtherContactMethodType getOtherContactMethod() {
            return otherContactMethod;
        }

        /** 
         * Set the 'OtherContactMethod' element value.
         * 
         * @param otherContactMethod
         */
        public void setOtherContactMethod(
                OtherContactMethodType otherContactMethod) {
            this.otherContactMethod = otherContactMethod;
        }

        /** 
         * Get the 'PhoneContact' element value.
         * 
         * @return value
         */
        public PhoneContact getPhoneContact() {
            return phoneContact;
        }

        /** 
         * Set the 'PhoneContact' element value.
         * 
         * @param phoneContact
         */
        public void setPhoneContact(PhoneContact phoneContact) {
            this.phoneContact = phoneContact;
        }

        /** 
         * Get the 'Name' element value.
         * 
         * @return value
         */
        public Name getName() {
            return name;
        }

        /** 
         * Set the 'Name' element value.
         * 
         * @param name
         */
        public void setName(Name name) {
            this.name = name;
        }

        /** 
         * Get the 'ContactType' attribute value. Type of contact. For e.g. Primary or Emergency contact.
         * 
         * @return value
         */
        public String getContactType() {
            return contactType;
        }

        /** 
         * Set the 'ContactType' attribute value. Type of contact. For e.g. Primary or Emergency contact.
         * 
         * @param contactType
         */
        public void setContactType(String contactType) {
            this.contactType = contactType;
        }
        /** 
         * Passenger Name information.

        Note: Detailed Name information, such as prefix, title and suffix, are specified in PassengerMetadata.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Name" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Surname">
         *         &lt;xs:complexType>
         *           &lt;xs:simpleContent>
         *             &lt;xs:extension base="xs:string">
         *               &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
         *             &lt;/xs:extension>
         *           &lt;/xs:simpleContent>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="Given" minOccurs="0" maxOccurs="5">
         *         &lt;!-- Reference to inner class Given -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="Title" minOccurs="0"/>
         *       &lt;xs:element name="SurnameSuffix" minOccurs="0"/>
         *       &lt;xs:element name="Middle" minOccurs="0" maxOccurs="3">
         *         &lt;!-- Reference to inner class Middle -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ObjectPolicyMetaAttrGroup"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class Name implements Serializable
        {
            private String surnameString;
            private String surnameRefs;
            private List<Given> givenList = new ArrayList<Given>();
            private String title;
            private boolean surnameSuffix;
            private List<Middle> middleList = new ArrayList<Middle>();
            private ObjectPolicyMetaAttrGroup objectPolicyMetaAttrGroup;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getSurnameString() {
                return surnameString;
            }

            /** 
             * Set the extension value.
             * 
             * @param surnameString
             */
            public void setSurnameString(String surnameString) {
                this.surnameString = surnameString;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getSurnameRefs() {
                return surnameRefs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param surnameRefs
             */
            public void setSurnameRefs(String surnameRefs) {
                this.surnameRefs = surnameRefs;
            }

            /** 
             * Get the list of 'Given' element items.
             * 
             * @return list
             */
            public List<Given> getGivenList() {
                return givenList;
            }

            /** 
             * Set the list of 'Given' element items.
             * 
             * @param list
             */
            public void setGivenList(List<Given> list) {
                givenList = list;
            }

            /** 
             * Get the 'Title' element value. Name Title. Examples: MR, MRS, DR
             * 
             * @return value
             */
            public String getTitle() {
                return title;
            }

            /** 
             * Set the 'Title' element value. Name Title. Examples: MR, MRS, DR
             * 
             * @param title
             */
            public void setTitle(String title) {
                this.title = title;
            }

            /** 
             * Check if the 'SurnameSuffix' element is present.
             * 
             * @return <code>true</code> if present, <code>false</code> if not
             */
            public boolean ifSurnameSuffixPresent() {
                return surnameSuffix;
            }

            /** 
             * Set flag for 'SurnameSuffix' element present.
             * 
             * @param surnameSuffix
             */
            public void flagSurnameSuffixPresent(boolean surnameSuffix) {
                this.surnameSuffix = surnameSuffix;
            }

            /** 
             * Get the list of 'Middle' element items.
             * 
             * @return list
             */
            public List<Middle> getMiddleList() {
                return middleList;
            }

            /** 
             * Set the list of 'Middle' element items.
             * 
             * @param list
             */
            public void setMiddleList(List<Middle> list) {
                middleList = list;
            }

            /** 
             * Get the 'ObjectPolicyMetaAttrGroup' attributeGroup value.
             * 
             * @return value
             */
            public ObjectPolicyMetaAttrGroup getObjectPolicyMetaAttrGroup() {
                return objectPolicyMetaAttrGroup;
            }

            /** 
             * Set the 'ObjectPolicyMetaAttrGroup' attributeGroup value.
             * 
             * @param objectPolicyMetaAttrGroup
             */
            public void setObjectPolicyMetaAttrGroup(
                    ObjectPolicyMetaAttrGroup objectPolicyMetaAttrGroup) {
                this.objectPolicyMetaAttrGroup = objectPolicyMetaAttrGroup;
            }
            /** 
             * Given name, first name or names
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Given" minOccurs="0" maxOccurs="5">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * 
             * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
             *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
             * &lt;/xs:attributeGroup>
             * </pre>
             */
            public static class Given implements Serializable
            {
                private String string;
                private String refs;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getRefs() {
                    return refs;
                }

                /** 
                 * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param refs
                 */
                public void setRefs(String refs) {
                    this.refs = refs;
                }
            }
            /** 
             * Middle name or initial.  Examples: G, GEORGE
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Middle" minOccurs="0" maxOccurs="3">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * 
             * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
             *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
             * &lt;/xs:attributeGroup>
             * </pre>
             */
            public static class Middle implements Serializable
            {
                private String string;
                private String refs;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @return value
                 */
                public String getRefs() {
                    return refs;
                }

                /** 
                 * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
                 * 
                 * @param refs
                 */
                public void setRefs(String refs) {
                    this.refs = refs;
                }
            }
        }
    }
}
