
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import org.joda.time.LocalDate;

/** 
 * A data type definition for Effective/ Expiration Short Date Period Representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DatePeriodType">
 *   &lt;xs:attribute type="xs:date" use="optional" name="Effective"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="Expiration"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DatePeriodType implements Serializable
{
    private LocalDate effective;
    private LocalDate expiration;

    /** 
     * Get the 'Effective' attribute value. Effective (start) Date.  Example: 2017-01-13

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @return value
     */
    public LocalDate getEffective() {
        return effective;
    }

    /** 
     * Set the 'Effective' attribute value. Effective (start) Date.  Example: 2017-01-13

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @param effective
     */
    public void setEffective(LocalDate effective) {
        this.effective = effective;
    }

    /** 
     * Get the 'Expiration' attribute value. Expiration (end) Date.  Example: 2017-01-14

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @return value
     */
    public LocalDate getExpiration() {
        return expiration;
    }

    /** 
     * Set the 'Expiration' attribute value. Expiration (end) Date.  Example: 2017-01-14

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @param expiration
     */
    public void setExpiration(LocalDate expiration) {
        this.expiration = expiration;
    }
}
