
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import org.joda.time.DateTime;

/** 
 * A data type for Effective/ Expiration Date And Time Period Representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DateTimePeriodRepType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:dateTime" name="Effective" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="Expiration" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DateTimePeriodRepType implements Serializable
{
    private DateTime effective;
    private DateTime expiration;

    /** 
     * Get the 'Effective' element value. Effective (start) date/ time.  Example: 2017-01-13T06:00:00
     * 
     * @return value
     */
    public DateTime getEffective() {
        return effective;
    }

    /** 
     * Set the 'Effective' element value. Effective (start) date/ time.  Example: 2017-01-13T06:00:00
     * 
     * @param effective
     */
    public void setEffective(DateTime effective) {
        this.effective = effective;
    }

    /** 
     * Get the 'Expiration' element value. Expiration (end) date/ time.  Example: 2017-03-13T23:00:00
     * 
     * @return value
     */
    public DateTime getExpiration() {
        return expiration;
    }

    /** 
     * Set the 'Expiration' element value. Expiration (end) date/ time.  Example: 2017-03-13T23:00:00
     * 
     * @param expiration
     */
    public void setExpiration(DateTime expiration) {
        this.expiration = expiration;
    }
}
