
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * DESCRIPTION definition.NDC Capability Model: Descriptions

 REPRESENTATIONS
 ============
 • Source URL
 • Plain Text
 • Marked-Up Text
 • Rich Media Object ID and/ or URL to Source (e.g. images and streaming video)
 ============
 ====
 Feature(s)

 a) Rendering Instructions, for converting an attachment into a specified display format, may be included with Media Attachments.
 3. Metadata: Yes

 2. Rendering Instructions, for converting an attachment into a specified display format, may be included with Media Attachments.

 3. These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of this capability is not dictated by this specification.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DescriptionType">
 *   &lt;xs:sequence>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Text" minOccurs="0">
 *         &lt;!-- Reference to inner class Text -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="xs:string" name="MarkupStyle" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:element type="xs:string" name="Link" minOccurs="0"/>
 *     &lt;xs:element name="Media" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Media -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ObjectKey"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class DescriptionType implements Serializable
{
    private Text text;
    private String markupStyle;
    private String link;
    private List<Media> mediaList = new ArrayList<Media>();
    private String refs;
    private String objectKey;

    /** 
     * Get the 'Text' element value.
     * 
     * @return value
     */
    public Text getText() {
        return text;
    }

    /** 
     * Set the 'Text' element value.
     * 
     * @param text
     */
    public void setText(Text text) {
        this.text = text;
    }

    /** 
     * Get the 'MarkupStyle' element value. Mark-up Style. Example: HTML
     * 
     * @return value
     */
    public String getMarkupStyle() {
        return markupStyle;
    }

    /** 
     * Set the 'MarkupStyle' element value. Mark-up Style. Example: HTML
     * 
     * @param markupStyle
     */
    public void setMarkupStyle(String markupStyle) {
        this.markupStyle = markupStyle;
    }

    /** 
     * Get the 'Link' element value. LINK to Description information source.
     * 
     * @return value
     */
    public String getLink() {
        return link;
    }

    /** 
     * Set the 'Link' element value. LINK to Description information source.
     * 
     * @param link
     */
    public void setLink(String link) {
        this.link = link;
    }

    /** 
     * Get the list of 'Media' element items.
     * 
     * @return list
     */
    public List<Media> getMediaList() {
        return mediaList;
    }

    /** 
     * Set the list of 'Media' element items.
     * 
     * @param list
     */
    public void setMediaList(List<Media> list) {
        mediaList = list;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    /** 
     * Get the 'ObjectKey' attribute value. Object globally unique Instance ID. Example: obj1
     * 
     * @return value
     */
    public String getObjectKey() {
        return objectKey;
    }

    /** 
     * Set the 'ObjectKey' attribute value. Object globally unique Instance ID. Example: obj1
     * 
     * @param objectKey
     */
    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }
    /** 
     * Description value.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Text" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Text implements Serializable
    {
        private String string;
        private String refs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
    /** 
     * Description-associated Media Object(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Media" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element type="UniqueIDContextType" name="ObjectID"/>
     *       &lt;xs:element ref="MediaLink"/>
     *       &lt;xs:element type="UniqueIDContextType" name="AttachmentID"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Media implements Serializable
    {
        private int mediaListSelect = -1;
        private static final int OBJECT_ID_CHOICE = 0;
        private static final int MEDIA_LINK_CHOICE = 1;
        private static final int ATTACHMENT_ID_CHOICE = 2;
        private UniqueIDContextType objectID;
        private MediaLink mediaLink;
        private UniqueIDContextType attachmentID;

        private void setMediaListSelect(int choice) {
            if (mediaListSelect == -1) {
                mediaListSelect = choice;
            } else if (mediaListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearMediaListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearMediaListSelect() {
            mediaListSelect = -1;
        }

        /** 
         * Check if ObjectID is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifObjectID() {
            return mediaListSelect == OBJECT_ID_CHOICE;
        }

        /** 
         * Get the 'ObjectID' element value. Description-associated MEDIA OBJECT ID or Key. Example: IMG1
         * 
         * @return value
         */
        public UniqueIDContextType getObjectID() {
            return objectID;
        }

        /** 
         * Set the 'ObjectID' element value. Description-associated MEDIA OBJECT ID or Key. Example: IMG1
         * 
         * @param objectID
         */
        public void setObjectID(UniqueIDContextType objectID) {
            setMediaListSelect(OBJECT_ID_CHOICE);
            this.objectID = objectID;
        }

        /** 
         * Check if MediaLink is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifMediaLink() {
            return mediaListSelect == MEDIA_LINK_CHOICE;
        }

        /** 
         * Get the 'MediaLink' element value. Description-associated MEDIA LINK.
         * 
         * @return value
         */
        public MediaLink getMediaLink() {
            return mediaLink;
        }

        /** 
         * Set the 'MediaLink' element value. Description-associated MEDIA LINK.
         * 
         * @param mediaLink
         */
        public void setMediaLink(MediaLink mediaLink) {
            setMediaListSelect(MEDIA_LINK_CHOICE);
            this.mediaLink = mediaLink;
        }

        /** 
         * Check if AttachmentID is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAttachmentID() {
            return mediaListSelect == ATTACHMENT_ID_CHOICE;
        }

        /** 
         * Get the 'AttachmentID' element value. Description-associated Media Attachment ID. Example: ATT1.
         * 
         * @return value
         */
        public UniqueIDContextType getAttachmentID() {
            return attachmentID;
        }

        /** 
         * Set the 'AttachmentID' element value. Description-associated Media Attachment ID. Example: ATT1.
         * 
         * @param attachmentID
         */
        public void setAttachmentID(UniqueIDContextType attachmentID) {
            setMediaListSelect(ATTACHMENT_ID_CHOICE);
            this.attachmentID = attachmentID;
        }
    }
}
