
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * DETAIL CURRENCY PRICE BASIS UNIT: Price with tax and/ or fee break-down or totals.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DetailCurrencyPriceType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="PriceCoreType">
 *       &lt;xs:sequence>
 *         &lt;xs:choice>
 *           &lt;xs:element type="CurrencyAmountOptType" name="Total"/>
 *           &lt;xs:element name="Equivalent"/>
 *         &lt;/xs:choice>
 *         &lt;xs:element name="Details" minOccurs="0">
 *           &lt;!-- Reference to inner class Details -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="TaxDetailType" name="Taxes" minOccurs="0"/>
 *         &lt;xs:element type="FeeSurchargeType" name="Fees" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DetailCurrencyPriceType extends PriceCoreType implements
    Serializable
{
    private int choiceSelect = -1;
    private static final int TOTAL_CHOICE = 0;
    private static final int EQUIVALENT_CHOICE = 1;
    private CurrencyAmountOptType total;
    private boolean equivalent;
    private Details details;
    private TaxDetailType taxes;
    private FeeSurchargeType fees;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Total is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTotal() {
        return choiceSelect == TOTAL_CHOICE;
    }

    /** 
     * Get the 'Total' element value. Total price in currency.  Example: 16000 USD

    Note: This is the total price INCLUDING base price, taxes and fees/ surcharges.
     * 
     * @return value
     */
    public CurrencyAmountOptType getTotal() {
        return total;
    }

    /** 
     * Set the 'Total' element value. Total price in currency.  Example: 16000 USD

    Note: This is the total price INCLUDING base price, taxes and fees/ surcharges.
     * 
     * @param total
     */
    public void setTotal(CurrencyAmountOptType total) {
        setChoiceSelect(TOTAL_CHOICE);
        this.total = total;
    }

    /** 
     * Check if Equivalent is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEquivalent() {
        return choiceSelect == EQUIVALENT_CHOICE;
    }

    /** 
     * Check if the 'Equivalent' element is present.
     * 
     * @return <code>true</code> if present, <code>false</code> if not
     */
    public boolean ifEquivalentPresent() {
        return equivalent;
    }

    /** 
     * Set flag for 'Equivalent' element present.
     * 
     * @param equivalent
     */
    public void flagEquivalentPresent(boolean equivalent) {
        setChoiceSelect(EQUIVALENT_CHOICE);
        this.equivalent = equivalent;
    }

    /** 
     * Get the 'Details' element value.
     * 
     * @return value
     */
    public Details getDetails() {
        return details;
    }

    /** 
     * Set the 'Details' element value.
     * 
     * @param details
     */
    public void setDetails(Details details) {
        this.details = details;
    }

    /** 
     * Get the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
     * 
     * @return value
     */
    public TaxDetailType getTaxes() {
        return taxes;
    }

    /** 
     * Set the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
     * 
     * @param taxes
     */
    public void setTaxes(TaxDetailType taxes) {
        this.taxes = taxes;
    }

    /** 
     * Get the 'Fees' element value. Individual fee/ surcharge information would appear on the accountable document.
     * 
     * @return value
     */
    public FeeSurchargeType getFees() {
        return fees;
    }

    /** 
     * Set the 'Fees' element value. Individual fee/ surcharge information would appear on the accountable document.
     * 
     * @param fees
     */
    public void setFees(FeeSurchargeType fees) {
        this.fees = fees;
    }
    /** 
     * Details all price break-down item subtotals, which exclude taxes, fees and charges.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Details" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Detail" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Detail -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Details implements Serializable
    {
        private List<Detail> detailList = new ArrayList<Detail>();
        private String refs;

        /** 
         * Get the list of 'Detail' element items.
         * 
         * @return list
         */
        public List<Detail> getDetailList() {
            return detailList;
        }

        /** 
         * Set the list of 'Detail' element items.
         * 
         * @param list
         */
        public void setDetailList(List<Detail> list) {
            detailList = list;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
        /** 
         * Price details.

        Note: This price does not include taxes and fee/ surcharges.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Detail" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="CurrencyAmountOptType" name="SubTotal" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="RefundInd"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class Detail implements Serializable
        {
            private CurrencyAmountOptType subTotal;
            private String application;
            private String refs;
            private Boolean refundInd;

            /** 
             * Get the 'SubTotal' element value. Price breakdown sub-total.

            Note: This is the total of all price breakdown items, excluding tax and/ or surcharge.
             * 
             * @return value
             */
            public CurrencyAmountOptType getSubTotal() {
                return subTotal;
            }

            /** 
             * Set the 'SubTotal' element value. Price breakdown sub-total.

            Note: This is the total of all price breakdown items, excluding tax and/ or surcharge.
             * 
             * @param subTotal
             */
            public void setSubTotal(CurrencyAmountOptType subTotal) {
                this.subTotal = subTotal;
            }

            /** 
             * Get the 'Application' element value. Price application. Example: Base Fare
             * 
             * @return value
             */
            public String getApplication() {
                return application;
            }

            /** 
             * Set the 'Application' element value. Price application. Example: Base Fare
             * 
             * @param application
             */
            public void setApplication(String application) {
                this.application = application;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }

            /** 
             * Get the 'RefundInd' attribute value. When true, this price amount is refundable.
             * 
             * @return value
             */
            public Boolean getRefundInd() {
                return refundInd;
            }

            /** 
             * Set the 'RefundInd' attribute value. When true, this price amount is refundable.
             * 
             * @param refundInd
             */
            public void setRefundInd(Boolean refundInd) {
                this.refundInd = refundInd;
            }
        }
    }
}
