
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Diagnostics">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Diagnostic" minOccurs="0" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class Diagnostic -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Diagnostics implements Serializable
{
    private List<Diagnostic> diagnosticList = new ArrayList<Diagnostic>();

    /** 
     * Get the list of 'Diagnostic' element items.
     * 
     * @return list
     */
    public List<Diagnostic> getDiagnosticList() {
        return diagnosticList;
    }

    /** 
     * Set the list of 'Diagnostic' element items.
     * 
     * @param list
     */
    public void setDiagnosticList(List<Diagnostic> list) {
        diagnosticList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Diagnostic" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence minOccurs="0">
     *       &lt;!-- Reference to inner class DiagnosticInner -->
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Diagnostic implements Serializable
    {
        private DiagnosticInner ID;

        /** 
         * Get the 'Diagnostic' element value.
         * 
         * @return value
         */
        public DiagnosticInner getID() {
            return ID;
        }

        /** 
         * Set the 'Diagnostic' element value.
         * 
         * @param ID
         */
        public void setID(DiagnosticInner ID) {
            this.ID = ID;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:sequence xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
         *   &lt;xs:element type="xs:string" name="ID" minOccurs="0"/>
         *   &lt;xs:element type="xs:string" name="QueryDuration" minOccurs="0"/>
         *   &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
         * &lt;/xs:sequence>
         * </pre>
         */
        public static class DiagnosticInner implements Serializable
        {
            private String ID;
            private String queryDuration;
            private String name;

            /** 
             * Get the 'ID' element value. Unique ID. Example 6
             * 
             * @return value
             */
            public String getID() {
                return ID;
            }

            /** 
             * Set the 'ID' element value. Unique ID. Example 6
             * 
             * @param ID
             */
            public void setID(String ID) {
                this.ID = ID;
            }

            /** 
             * Get the 'QueryDuration' element value. Denotes the time the query spent processing with pricing provider before response is returned
             * 
             * @return value
             */
            public String getQueryDuration() {
                return queryDuration;
            }

            /** 
             * Set the 'QueryDuration' element value. Denotes the time the query spent processing with pricing provider before response is returned
             * 
             * @param queryDuration
             */
            public void setQueryDuration(String queryDuration) {
                this.queryDuration = queryDuration;
            }

            /** 
             * Get the 'Name' element value. Pricing Provider Name 
             * 
             * @return value
             */
            public String getName() {
                return name;
            }

            /** 
             * Set the 'Name' element value. Pricing Provider Name 
             * 
             * @param name
             */
            public void setName(String name) {
                this.name = name;
            }
        }
    }
}
