
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Disclosure(s).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DisclosureType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="DescriptionType" name="Description" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class DisclosureType implements Serializable
{
    private List<DescriptionType> descriptionList = new ArrayList<DescriptionType>();
    private String refs;

    /** 
     * Get the list of 'Description' element items. Plain Text or Rich Media Disclosure Description(s).
     * 
     * @return list
     */
    public List<DescriptionType> getDescriptionList() {
        return descriptionList;
    }

    /** 
     * Set the list of 'Description' element items. Plain Text or Rich Media Disclosure Description(s).
     * 
     * @param list
     */
    public void setDescriptionList(List<DescriptionType> list) {
        descriptionList = list;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
