
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * COUPON-RELATED FARE INFORMATION definition.

 Account code, net reporting code, nonendorsable and nonrefundable indicators, penalty restriction indicator, pricing system, statistical code and tour code.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ET_FareInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Waiver" minOccurs="0" maxOccurs="5">
 *       &lt;!-- Reference to inner class Waiver -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="RuleInd" minOccurs="0" maxOccurs="5">
 *       &lt;!-- Reference to inner class RuleInd -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Detail" minOccurs="0">
 *       &lt;!-- Reference to inner class Detail -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class ETFareInfoType implements Serializable
{
    private List<Waiver> waiverList = new ArrayList<Waiver>();
    private List<RuleInd> ruleIndList = new ArrayList<RuleInd>();
    private Detail detail;
    private String refs;

    /** 
     * Get the list of 'Waiver' element items.
     * 
     * @return list
     */
    public List<Waiver> getWaiverList() {
        return waiverList;
    }

    /** 
     * Set the list of 'Waiver' element items.
     * 
     * @param list
     */
    public void setWaiverList(List<Waiver> list) {
        waiverList = list;
    }

    /** 
     * Get the list of 'RuleInd' element items.
     * 
     * @return list
     */
    public List<RuleInd> getRuleIndList() {
        return ruleIndList;
    }

    /** 
     * Set the list of 'RuleInd' element items.
     * 
     * @param list
     */
    public void setRuleIndList(List<RuleInd> list) {
        ruleIndList = list;
    }

    /** 
     * Get the 'Detail' element value.
     * 
     * @return value
     */
    public Detail getDetail() {
        return detail;
    }

    /** 
     * Set the 'Detail' element value.
     * 
     * @param detail
     */
    public void setDetail(Detail detail) {
        this.detail = detail;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Validating Carrier-assigned Fare Rule Modification or Override information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Waiver" minOccurs="0" maxOccurs="5">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Code" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Type" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Waiver implements Serializable
    {
        private String code;
        private String type;

        /** 
         * Get the 'Code' element value. Fare Rule Waiver Code.

        Note: This is a code assigned by the validating carrier that allows fare rule modification or override.
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' element value. Fare Rule Waiver Code.

        Note: This is a code assigned by the validating carrier that allows fare rule modification or override.
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'Type' element value. Fare Waiver Rule Type. Examples: ExchangeReissued, FareComponent
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'Type' element value. Fare Waiver Rule Type. Examples: ExchangeReissued, FareComponent
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }
    }
    /** 
     * ATPCO Ticket Fare Category information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleInd" minOccurs="0" maxOccurs="5">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:integer" name="RuleCode"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class RuleInd implements Serializable
    {
        private BigInteger ruleCode;

        /** 
         * Get the 'RuleCode' element value. ATPCO fare category number.
         * 
         * @return value
         */
        public BigInteger getRuleCode() {
            return ruleCode;
        }

        /** 
         * Set the 'RuleCode' element value. ATPCO fare category number.
         * 
         * @param ruleCode
         */
        public void setRuleCode(BigInteger ruleCode) {
            this.ruleCode = ruleCode;
        }
    }
    /** 
     * Detail information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Detail" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="NetReportingCode" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="StatisticalCode" minOccurs="0"/>
     *       &lt;xs:element ref="TourCode" minOccurs="0"/>
     *       &lt;xs:element ref="CountryCode" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="PricingSystemCode" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Detail implements Serializable
    {
        private String netReportingCode;
        private String statisticalCode;
        private TourCode tourCode;
        private CountryCodeType countryCode;
        private String pricingSystemCode;

        /** 
         * Get the 'NetReportingCode' element value. Net Reporting Code.

        Note: This is a code indicating if the transaction is subject to a net reporting arrangement.
         * 
         * @return value
         */
        public String getNetReportingCode() {
            return netReportingCode;
        }

        /** 
         * Set the 'NetReportingCode' element value. Net Reporting Code.

        Note: This is a code indicating if the transaction is subject to a net reporting arrangement.
         * 
         * @param netReportingCode
         */
        public void setNetReportingCode(String netReportingCode) {
            this.netReportingCode = netReportingCode;
        }

        /** 
         * Get the 'StatisticalCode' element value. Statistical code.

        Note; This is used for domestic or international sales differentiation.
         * 
         * @return value
         */
        public String getStatisticalCode() {
            return statisticalCode;
        }

        /** 
         * Set the 'StatisticalCode' element value. Statistical code.

        Note; This is used for domestic or international sales differentiation.
         * 
         * @param statisticalCode
         */
        public void setStatisticalCode(String statisticalCode) {
            this.statisticalCode = statisticalCode;
        }

        /** 
         * Get the 'TourCode' element value.
         * 
         * @return value
         */
        public TourCode getTourCode() {
            return tourCode;
        }

        /** 
         * Set the 'TourCode' element value.
         * 
         * @param tourCode
         */
        public void setTourCode(TourCode tourCode) {
            this.tourCode = tourCode;
        }

        /** 
         * Get the 'CountryCode' element value. Country code where the ticket is issued. Example: US

        Encoding Scheme: ISO 3166-1 (two character) Country Code
         * 
         * @return value
         */
        public CountryCodeType getCountryCode() {
            return countryCode;
        }

        /** 
         * Set the 'CountryCode' element value. Country code where the ticket is issued. Example: US

        Encoding Scheme: ISO 3166-1 (two character) Country Code
         * 
         * @param countryCode
         */
        public void setCountryCode(CountryCodeType countryCode) {
            this.countryCode = countryCode;
        }

        /** 
         * Get the 'PricingSystemCode' element value. The two/three character IATA assigned code identifying the system used to price the itinerary for the document being issued.
         * 
         * @return value
         */
        public String getPricingSystemCode() {
            return pricingSystemCode;
        }

        /** 
         * Set the 'PricingSystemCode' element value. The two/three character IATA assigned code identifying the system used to price the itinerary for the document being issued.
         * 
         * @param pricingSystemCode
         */
        public void setPricingSystemCode(String pricingSystemCode) {
            this.pricingSystemCode = pricingSystemCode;
        }
    }
}
