
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * EMAIL ADDRESS helper object.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EmailType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
 *     &lt;xs:element type="EmailID_Type" name="Address"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class EmailType implements Serializable
{
    private String application;
    private EmailIDType address;
    private String refs;

    /** 
     * Get the 'Application' element value. Email address application. Examples: Personal, Business, SMS
     * 
     * @return value
     */
    public String getApplication() {
        return application;
    }

    /** 
     * Set the 'Application' element value. Email address application. Examples: Personal, Business, SMS
     * 
     * @param application
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /** 
     * Get the 'Address' element value. The traveler email address for contact.
     * 
     * @return value
     */
    public EmailIDType getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value. The traveler email address for contact.
     * 
     * @param address
     */
    public void setAddress(EmailIDType address) {
        this.address = address;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
