
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type definition for Encoding Scheme Source Provider Type list constraint.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EncSchemeSimpleType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Airline"/>
 *     &lt;xs:enumeration value="Filed"/>
 *     &lt;xs:enumeration value="ThirdParty"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EncSchemeSimpleType implements Serializable {
    AIRLINE("Airline"), FILED("Filed"), THIRD_PARTY("ThirdParty");
    private final String value;

    private EncSchemeSimpleType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EncSchemeSimpleType convert(String value) {
        for (EncSchemeSimpleType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
