
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * FARE DETAIL definition.NDC Capability Model: FARE - FARE DETAIL

 ============
 Representation(s)
 ============
 • Fare Component information
 • Fare Rules information

 ============
 Feature(s)
 ============
 • Fare Code Indicator to represent pricing method (IATA PADIS Code List for data element 5387 - Price Type Qualifier)
 • Price Class association
 • Associated Flight Mileage
 • Fare Remarks
 • Tour Code support (A special code arranged between the travel agency and the sales representative for a particular airline. When the agent enters the tour code into the reservation and ticketing system, it will input certain information onto the ticket. For example, agent commisions, specific fare fules that supercede the published fare rules etc.)

 ============
 Metadata
 ============
 • FareMetadata
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareDetailType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="FareIndicatorCode" minOccurs="0">
 *       &lt;!-- Reference to inner class FareIndicatorCode -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="PassengerRefs" minOccurs="0"/>
 *     &lt;xs:element type="FarePriceDetailType" name="Price"/>
 *     &lt;xs:element type="FareComponentType" name="FareComponent" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element ref="FlightMileage" minOccurs="0"/>
 *     &lt;xs:element ref="TourCode" minOccurs="0"/>
 *     &lt;xs:element ref="Remarks" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareDetailType implements Serializable
{
    private FareIndicatorCode fareIndicatorCode;
    private String passengerRefs;
    private FarePriceDetailType price;
    private List<FareComponentType> fareComponentList = new ArrayList<FareComponentType>();
    private FlightMileageType flightMileage;
    private TourCode tourCode;
    private Remarks remarks;

    /** 
     * Get the 'FareIndicatorCode' element value.
     * 
     * @return value
     */
    public FareIndicatorCode getFareIndicatorCode() {
        return fareIndicatorCode;
    }

    /** 
     * Set the 'FareIndicatorCode' element value.
     * 
     * @param fareIndicatorCode
     */
    public void setFareIndicatorCode(FareIndicatorCode fareIndicatorCode) {
        this.fareIndicatorCode = fareIndicatorCode;
    }

    /** 
     * Get the 'PassengerRefs' element value. Passengers associated with the specific Fare Detail instance. Allows the Price breakdown of the fare for the offeritem per passenger.
     * 
     * @return value
     */
    public String getPassengerRefs() {
        return passengerRefs;
    }

    /** 
     * Set the 'PassengerRefs' element value. Passengers associated with the specific Fare Detail instance. Allows the Price breakdown of the fare for the offeritem per passenger.
     * 
     * @param passengerRefs
     */
    public void setPassengerRefs(String passengerRefs) {
        this.passengerRefs = passengerRefs;
    }

    /** 
     * Get the 'Price' element value. Total price of all FareComponent prices. Price reflects a per-passenger price referenced within this FareDetail.
     * 
     * @return value
     */
    public FarePriceDetailType getPrice() {
        return price;
    }

    /** 
     * Set the 'Price' element value. Total price of all FareComponent prices. Price reflects a per-passenger price referenced within this FareDetail.
     * 
     * @param price
     */
    public void setPrice(FarePriceDetailType price) {
        this.price = price;
    }

    /** 
     * Get the list of 'FareComponent' element items. Fare Component information with Price Breakdown.
     * 
     * @return list
     */
    public List<FareComponentType> getFareComponentList() {
        return fareComponentList;
    }

    /** 
     * Set the list of 'FareComponent' element items. Fare Component information with Price Breakdown.
     * 
     * @param list
     */
    public void setFareComponentList(List<FareComponentType> list) {
        fareComponentList = list;
    }

    /** 
     * Get the 'FlightMileage' element value.
     * 
     * @return value
     */
    public FlightMileageType getFlightMileage() {
        return flightMileage;
    }

    /** 
     * Set the 'FlightMileage' element value.
     * 
     * @param flightMileage
     */
    public void setFlightMileage(FlightMileageType flightMileage) {
        this.flightMileage = flightMileage;
    }

    /** 
     * Get the 'TourCode' element value.
     * 
     * @return value
     */
    public TourCode getTourCode() {
        return tourCode;
    }

    /** 
     * Set the 'TourCode' element value.
     * 
     * @param tourCode
     */
    public void setTourCode(TourCode tourCode) {
        this.tourCode = tourCode;
    }

    /** 
     * Get the 'Remarks' element value.
     * 
     * @return value
     */
    public Remarks getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value.
     * 
     * @param remarks
     */
    public void setRemarks(Remarks remarks) {
        this.remarks = remarks;
    }
    /** 
     * Fare code indicator.  Example: 1 (SYSTEM PRICED WITHOUT MANUAL INTERVENTION)

    Encoding Scheme: IATA PADIS Code List for data element 5387 - Price Type Qualifier
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareIndicatorCode" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:boolean" name="FiledFareInd"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FareIndicatorCode implements Serializable
    {
        private String string;
        private Boolean filedFareInd;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'FiledFareInd' attribute value. A component of this item has been priced using filed fare data;
        True = Partially or All Filed
        False or missing = All dynamic
         * 
         * @return value
         */
        public Boolean getFiledFareInd() {
            return filedFareInd;
        }

        /** 
         * Set the 'FiledFareInd' attribute value. A component of this item has been priced using filed fare data;
        True = Partially or All Filed
        False or missing = All dynamic
         * 
         * @param filedFareInd
         */
        public void setFiledFareInd(Boolean filedFareInd) {
            this.filedFareInd = filedFareInd;
        }
    }
}
