
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * Fare Text Indicator. Examples: A (Full Text), B (Mini Rule)
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareTextInd">
 *   &lt;xs:simpleType>
 *     &lt;!-- Reference to inner class FareTextIndInner -->
 *   &lt;/xs:simpleType>
 * &lt;/xs:element>
 * </pre>
 */
public class FareTextInd implements Serializable
{
    private FareTextIndInner fareTextInd;

    /** 
     * Get the 'FareTextInd' element value.
     * 
     * @return value
     */
    public FareTextIndInner getFareTextInd() {
        return fareTextInd;
    }

    /** 
     * Set the 'FareTextInd' element value.
     * 
     * @param fareTextInd
     */
    public void setFareTextInd(FareTextIndInner fareTextInd) {
        this.fareTextInd = fareTextInd;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="FullText"/>
     *     &lt;xs:enumeration value="MiniRule"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum FareTextIndInner implements Serializable {
        FULL_TEXT("FullText"), MINI_RULE("MiniRule");
        private final String value;

        private FareTextIndInner(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static FareTextIndInner convert(String value) {
            for (FareTextIndInner inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
