
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Fees claimed for all services charged with this Ticket.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FeeGroup">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Fee" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class Fee -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:integer" use="required" name="Amount"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class FeeGroup implements Serializable
{
    private List<Fee> feeList = new ArrayList<Fee>();
    private BigInteger amount;

    /** 
     * Get the list of 'Fee' element items.
     * 
     * @return list
     */
    public List<Fee> getFeeList() {
        return feeList;
    }

    /** 
     * Set the list of 'Fee' element items.
     * 
     * @param list
     */
    public void setFeeList(List<Fee> list) {
        feeList = list;
    }

    /** 
     * Get the 'Amount' attribute value. Total fee amount for the Fare
    Example: 200000
     * 
     * @return value
     */
    public BigInteger getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' attribute value. Total fee amount for the Fare
    Example: 200000
     * 
     * @param amount
     */
    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fee" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:integer" name="Amount"/>
     *       &lt;xs:element name="BasePrice" minOccurs="0">
     *         &lt;!-- Reference to inner class BasePrice -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Taxes" minOccurs="0">
     *         &lt;!-- Reference to inner class Taxes -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
     *       &lt;xs:element name="DescriptionDetails" minOccurs="0">
     *         &lt;!-- Reference to inner class DescriptionDetails -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PassengerRefs" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:anySimpleType" name="ServiceCode"/>
     *     &lt;xs:attribute type="xs:anySimpleType" name="SubCode"/>
     *     &lt;xs:attribute type="xs:string" name="Refundable"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Fee implements Serializable
    {
        private BigInteger amount;
        private BasePrice basePrice;
        private Taxes taxes;
        private String description;
        private DescriptionDetails descriptionDetails;
        private boolean passengerRefs;
        private String serviceCode;
        private String subCode;
        private String refundable;

        /** 
         * Get the 'Amount' element value. Fee amount including taxes. Example: 2000
         * 
         * @return value
         */
        public BigInteger getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' element value. Fee amount including taxes. Example: 2000
         * 
         * @param amount
         */
        public void setAmount(BigInteger amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'BasePrice' element value.
         * 
         * @return value
         */
        public BasePrice getBasePrice() {
            return basePrice;
        }

        /** 
         * Set the 'BasePrice' element value.
         * 
         * @param basePrice
         */
        public void setBasePrice(BasePrice basePrice) {
            this.basePrice = basePrice;
        }

        /** 
         * Get the 'Taxes' element value.
         * 
         * @return value
         */
        public Taxes getTaxes() {
            return taxes;
        }

        /** 
         * Set the 'Taxes' element value.
         * 
         * @param taxes
         */
        public void setTaxes(Taxes taxes) {
            this.taxes = taxes;
        }

        /** 
         * Get the 'Description' element value. Title description (Commercial Name) of Fee.

        Example: "Credit Card Fee"
         * 
         * @return value
         */
        public String getDescription() {
            return description;
        }

        /** 
         * Set the 'Description' element value. Title description (Commercial Name) of Fee.

        Example: "Credit Card Fee"
         * 
         * @param description
         */
        public void setDescription(String description) {
            this.description = description;
        }

        /** 
         * Get the 'DescriptionDetails' element value.
         * 
         * @return value
         */
        public DescriptionDetails getDescriptionDetails() {
            return descriptionDetails;
        }

        /** 
         * Set the 'DescriptionDetails' element value.
         * 
         * @param descriptionDetails
         */
        public void setDescriptionDetails(DescriptionDetails descriptionDetails) {
            this.descriptionDetails = descriptionDetails;
        }

        /** 
         * Check if the 'PassengerRefs' element is present.
         * 
         * @return <code>true</code> if present, <code>false</code> if not
         */
        public boolean ifPassengerRefsPresent() {
            return passengerRefs;
        }

        /** 
         * Set flag for 'PassengerRefs' element present.
         * 
         * @param passengerRefs
         */
        public void flagPassengerRefsPresent(boolean passengerRefs) {
            this.passengerRefs = passengerRefs;
        }

        /** 
         * Get the 'ServiceCode' attribute value. Additional unique ATPCO code. Please refer to FLX Codeset document for acceptable values.
        Example: OC
         * 
         * @return value
         */
        public String getServiceCode() {
            return serviceCode;
        }

        /** 
         * Set the 'ServiceCode' attribute value. Additional unique ATPCO code. Please refer to FLX Codeset document for acceptable values.
        Example: OC
         * 
         * @param serviceCode
         */
        public void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        /** 
         * Get the 'SubCode' attribute value. ATPCO RFISC (ReasonForIssuance  Subcode).
        Example of RFISC: 0CC
         * 
         * @return value
         */
        public String getSubCode() {
            return subCode;
        }

        /** 
         * Set the 'SubCode' attribute value. ATPCO RFISC (ReasonForIssuance  Subcode).
        Example of RFISC: 0CC
         * 
         * @param subCode
         */
        public void setSubCode(String subCode) {
            this.subCode = subCode;
        }

        /** 
         * Get the 'Refundable' attribute value. Indicates if fee is refundable.  Values are:
        Y = Fee refundable  N = Fee not refundable. If attribute is not there then
        default is Y.
         * 
         * @return value
         */
        public String getRefundable() {
            return refundable;
        }

        /** 
         * Set the 'Refundable' attribute value. Indicates if fee is refundable.  Values are:
        Y = Fee refundable  N = Fee not refundable. If attribute is not there then
        default is Y.
         * 
         * @param refundable
         */
        public void setRefundable(String refundable) {
            this.refundable = refundable;
        }
        /** 
         * Base (net) price of option.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BasePrice" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:integer" use="required" name="Amount"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class BasePrice implements Serializable
        {
            private BigInteger amount;

            /** 
             * Get the 'Amount' attribute value. Net price of option.
            Example: 6750
             * 
             * @return value
             */
            public BigInteger getAmount() {
                return amount;
            }

            /** 
             * Set the 'Amount' attribute value. Net price of option.
            Example: 6750
             * 
             * @param amount
             */
            public void setAmount(BigInteger amount) {
                this.amount = amount;
            }
        }
        /** 
         * Taxes Group
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Tax -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:integer" use="required" name="Amount"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Taxes implements Serializable
        {
            private List<Tax> taxList = new ArrayList<Tax>();
            private BigInteger amount;

            /** 
             * Get the list of 'Tax' element items.
             * 
             * @return list
             */
            public List<Tax> getTaxList() {
                return taxList;
            }

            /** 
             * Set the list of 'Tax' element items.
             * 
             * @param list
             */
            public void setTaxList(List<Tax> list) {
                taxList = list;
            }

            /** 
             * Get the 'Amount' attribute value. Total taxes amount.  Example: 50000
             * 
             * @return value
             */
            public BigInteger getAmount() {
                return amount;
            }

            /** 
             * Set the 'Amount' attribute value. Total taxes amount.  Example: 50000
             * 
             * @param amount
             */
            public void setAmount(BigInteger amount) {
                this.amount = amount;
            }
            /** 
             * Tax break down information group
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Designator" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="Nature" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
             *       &lt;xs:element name="Diagnostics" minOccurs="0">
             *         &lt;!-- Reference to inner class Diagnostics -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="CurrencyCode" minOccurs="0">
             *         &lt;!-- Reference to inner class CurrencyCode -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="LocalAmount" minOccurs="0"/>
             *       &lt;xs:element name="CollectionPoint" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class CollectionPoint -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:integer" use="required" name="Amount"/>
             *     &lt;xs:attribute use="optional" name="Refundable">
             *       &lt;xs:simpleType>
             *         &lt;!-- Reference to inner class Refundable -->
             *       &lt;/xs:simpleType>
             *     &lt;/xs:attribute>
             *     &lt;xs:attribute name="Paid">
             *       &lt;xs:simpleType>
             *         &lt;!-- Reference to inner class Paid -->
             *       &lt;/xs:simpleType>
             *     &lt;/xs:attribute>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Tax implements Serializable
            {
                private String designator;
                private String nature;
                private String description;
                private Diagnostics diagnostics;
                private CurrencyCode currencyCode;
                private boolean localAmount;
                private List<CollectionPoint> collectionPointList = new ArrayList<CollectionPoint>();
                private BigInteger amount;
                private Refundable refundable;
                private Paid paid;

                /** 
                 * Get the 'Designator' element value.
                 * 
                 * @return value
                 */
                public String getDesignator() {
                    return designator;
                }

                /** 
                 * Set the 'Designator' element value.
                 * 
                 * @param designator
                 */
                public void setDesignator(String designator) {
                    this.designator = designator;
                }

                /** 
                 * Get the 'Nature' element value.
                 * 
                 * @return value
                 */
                public String getNature() {
                    return nature;
                }

                /** 
                 * Set the 'Nature' element value.
                 * 
                 * @param nature
                 */
                public void setNature(String nature) {
                    this.nature = nature;
                }

                /** 
                 * Get the 'Description' element value.
                 * 
                 * @return value
                 */
                public String getDescription() {
                    return description;
                }

                /** 
                 * Set the 'Description' element value.
                 * 
                 * @param description
                 */
                public void setDescription(String description) {
                    this.description = description;
                }

                /** 
                 * Get the 'Diagnostics' element value.
                 * 
                 * @return value
                 */
                public Diagnostics getDiagnostics() {
                    return diagnostics;
                }

                /** 
                 * Set the 'Diagnostics' element value.
                 * 
                 * @param diagnostics
                 */
                public void setDiagnostics(Diagnostics diagnostics) {
                    this.diagnostics = diagnostics;
                }

                /** 
                 * Get the 'CurrencyCode' element value.
                 * 
                 * @return value
                 */
                public CurrencyCode getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'CurrencyCode' element value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(CurrencyCode currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Check if the 'LocalAmount' element is present.
                 * 
                 * @return <code>true</code> if present, <code>false</code> if not
                 */
                public boolean ifLocalAmountPresent() {
                    return localAmount;
                }

                /** 
                 * Set flag for 'LocalAmount' element present.
                 * 
                 * @param localAmount
                 */
                public void flagLocalAmountPresent(boolean localAmount) {
                    this.localAmount = localAmount;
                }

                /** 
                 * Get the list of 'CollectionPoint' element items.
                 * 
                 * @return list
                 */
                public List<CollectionPoint> getCollectionPointList() {
                    return collectionPointList;
                }

                /** 
                 * Set the list of 'CollectionPoint' element items.
                 * 
                 * @param list
                 */
                public void setCollectionPointList(List<CollectionPoint> list) {
                    collectionPointList = list;
                }

                /** 
                 * Get the 'Amount' attribute value. Individual tax amount.  Example: 6500
                 * 
                 * @return value
                 */
                public BigInteger getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value. Individual tax amount.  Example: 6500
                 * 
                 * @param amount
                 */
                public void setAmount(BigInteger amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'Refundable' attribute value. Indicates if tax is refundable.  Values are:
                Y = Tax refundable (default)
                N = Tax not refundable
                Example: N
                 * 
                 * @return value
                 */
                public Refundable getRefundable() {
                    return refundable;
                }

                /** 
                 * Set the 'Refundable' attribute value. Indicates if tax is refundable.  Values are:
                Y = Tax refundable (default)
                N = Tax not refundable
                Example: N
                 * 
                 * @param refundable
                 */
                public void setRefundable(Refundable refundable) {
                    this.refundable = refundable;
                }

                /** 
                 * Get the 'Paid' attribute value. Indicates the payment status of the tax. PD=Paid, RF=refunded 
                 * 
                 * @return value
                 */
                public Paid getPaid() {
                    return paid;
                }

                /** 
                 * Set the 'Paid' attribute value. Indicates the payment status of the tax. PD=Paid, RF=refunded 
                 * 
                 * @param paid
                 */
                public void setPaid(Paid paid) {
                    this.paid = paid;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Diagnostics" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:integer" use="optional" name="ID"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Diagnostics implements Serializable
                {
                    private String string;
                    private BigInteger ID;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'ID' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getID() {
                        return ID;
                    }

                    /** 
                     * Set the 'ID' attribute value.
                     * 
                     * @param ID
                     */
                    public void setID(BigInteger ID) {
                        this.ID = ID;
                    }
                }
                /** 
                 * Amount in local value
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrencyCode" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:integer" use="required" name="NumberOfDecimals"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CurrencyCode implements Serializable
                {
                    private String string;
                    private BigInteger numberOfDecimals;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'NumberOfDecimals' attribute value. Decimal position in fare amount.  Example: 2
                     * 
                     * @return value
                     */
                    public BigInteger getNumberOfDecimals() {
                        return numberOfDecimals;
                    }

                    /** 
                     * Set the 'NumberOfDecimals' attribute value. Decimal position in fare amount.  Example: 2
                     * 
                     * @param numberOfDecimals
                     */
                    public void setNumberOfDecimals(BigInteger numberOfDecimals) {
                        this.numberOfDecimals = numberOfDecimals;
                    }
                }
                /** 
                 * NOTE: this definition will eventually supercede the Calculation element. Use this  group instead of Calculation as Calculation will be deprecated in near future.

                For XF and ZP taxes. 
                Tax data break down for each collection point.  

                The sum of individual amounts entered here must  be equal to the Amount entered in the Tax element.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CollectionPoint" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="AirportCode"/>
                 *       &lt;xs:element name="AirportAmount"/>
                 *       &lt;xs:element name="CurrencyCode" minOccurs="0">
                 *         &lt;!-- Reference to inner class CurrencyCode -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:integer" name="Amount"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CollectionPoint implements Serializable
                {
                    private String airportCode;
                    private CurrencyCode currencyCode;
                    private BigInteger amount;

                    /** 
                     * Get the 'AirportCode' element value.
                     * 
                     * @return value
                     */
                    public String getAirportCode() {
                        return airportCode;
                    }

                    /** 
                     * Set the 'AirportCode' element value.
                     * 
                     * @param airportCode
                     */
                    public void setAirportCode(String airportCode) {
                        this.airportCode = airportCode;
                    }

                    /** 
                     * Get the 'CurrencyCode' element value.
                     * 
                     * @return value
                     */
                    public CurrencyCode getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' element value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(CurrencyCode currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'Amount' attribute value. Individual amount for collection point.  
                    Example: 2500
                     * 
                     * @return value
                     */
                    public BigInteger getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value. Individual amount for collection point.  
                    Example: 2500
                     * 
                     * @param amount
                     */
                    public void setAmount(BigInteger amount) {
                        this.amount = amount;
                    }
                    /** 
                     * Amount in local value
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrencyCode" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:string">
                     *         &lt;xs:attribute type="xs:integer" use="required" name="NumberOfDecimals"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CurrencyCode implements Serializable
                    {
                        private String string;
                        private BigInteger numberOfDecimals;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public String getString() {
                            return string;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param string
                         */
                        public void setString(String string) {
                            this.string = string;
                        }

                        /** 
                         * Get the 'NumberOfDecimals' attribute value. Decimal position in fare amount.  Example: 2
                         * 
                         * @return value
                         */
                        public BigInteger getNumberOfDecimals() {
                            return numberOfDecimals;
                        }

                        /** 
                         * Set the 'NumberOfDecimals' attribute value. Decimal position in fare amount.  Example: 2
                         * 
                         * @param numberOfDecimals
                         */
                        public void setNumberOfDecimals(
                                BigInteger numberOfDecimals) {
                            this.numberOfDecimals = numberOfDecimals;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                 *   &lt;xs:restriction base="xs:string">
                 *     &lt;xs:enumeration value="Y"/>
                 *     &lt;xs:enumeration value="N"/>
                 *   &lt;/xs:restriction>
                 * &lt;/xs:simpleType>
                 * </pre>
                 */
                public static enum Refundable implements Serializable {
                    Y, N
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                 *   &lt;xs:restriction base="xs:string">
                 *     &lt;xs:enumeration value="PD"/>
                 *     &lt;xs:enumeration value="RF"/>
                 *   &lt;/xs:restriction>
                 * &lt;/xs:simpleType>
                 * </pre>
                 */
                public static enum Paid implements Serializable {
                    PD, RF
                }
            }
        }
        /** 
         * Detailed description of this service
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DescriptionDetails" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="Text" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class DescriptionDetails implements Serializable
        {
            private List<String> textList = new ArrayList<String>();

            /** 
             * Get the list of 'Text' element items.
             * 
             * @return list
             */
            public List<String> getTextList() {
                return textList;
            }

            /** 
             * Set the list of 'Text' element items.
             * 
             * @param list
             */
            public void setTextList(List<String> list) {
                textList = list;
            }
        }
    }
}
