
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * FLIGHT DURATION with Application definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightDurationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Value"/>
 *     &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class FlightDurationType implements Serializable
{
    private String value;
    private String application;
    private String refs;

    /** 
     * Get the 'Value' element value. Flight Segment Duration.
    Example: PT6H45M (six hours and forty-five minutes)

    Note: This is the in-flight time duration associated with this segment. Stop duration is specified in the Stops node.
     * 
     * @return value
     */
    public String getValue() {
        return value;
    }

    /** 
     * Set the 'Value' element value. Flight Segment Duration.
    Example: PT6H45M (six hours and forty-five minutes)

    Note: This is the in-flight time duration associated with this segment. Stop duration is specified in the Stops node.
     * 
     * @param value
     */
    public void setValue(String value) {
        this.value = value;
    }

    /** 
     * Get the 'Application' element value. Flight Duration Application.
    Examples: FlightTime, ConnectionTime, TotalJourneyTime
     * 
     * @return value
     */
    public String getApplication() {
        return application;
    }

    /** 
     * Set the 'Application' element value. Flight Duration Application.
    Examples: FlightTime, ConnectionTime, TotalJourneyTime
     * 
     * @param application
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
