
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for INTERMEDIARY GROUP, Core Representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IntermediaryCoreRepType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ActorObjectType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Category" minOccurs="0"/>
 *         &lt;xs:element name="Contact" minOccurs="0" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class Contact -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class IntermediaryCoreRepType extends ActorObjectType implements
    Serializable
{
    private String name;
    private String category;
    private List<Contact> contactList = new ArrayList<Contact>();

    /** 
     * Get the 'Name' element value. Intermediary Name.  Example: Farelogix
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Intermediary Name.  Example: Farelogix
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'Category' element value. Intermediary Category.  Example: Aggregator, Consolidator
    Encoding Scheme: IATA Padis Codeset - Data element 9972 (Originator Type)
     * 
     * @return value
     */
    public String getCategory() {
        return category;
    }

    /** 
     * Set the 'Category' element value. Intermediary Category.  Example: Aggregator, Consolidator
    Encoding Scheme: IATA Padis Codeset - Data element 9972 (Originator Type)
     * 
     * @param category
     */
    public void setCategory(String category) {
        this.category = category;
    }

    /** 
     * Get the list of 'Contact' element items.
     * 
     * @return list
     */
    public List<Contact> getContactList() {
        return contactList;
    }

    /** 
     * Set the list of 'Contact' element items.
     * 
     * @param list
     */
    public void setContactList(List<Contact> list) {
        contactList = list;
    }
    /** 
     * Contact detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Contact" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="AddressContact"/>
     *       &lt;xs:element ref="EmailContact"/>
     *       &lt;xs:element ref="OtherContactMethod"/>
     *       &lt;xs:element ref="PhoneContact"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Contact implements Serializable
    {
        private int contactListSelect = -1;
        private static final int ADDRESS_CONTACT_CHOICE = 0;
        private static final int EMAIL_CONTACT_CHOICE = 1;
        private static final int OTHER_CONTACT_METHOD_CHOICE = 2;
        private static final int PHONE_CONTACT_CHOICE = 3;
        private AddressContact addressContact;
        private EmailType emailContact;
        private OtherContactMethodType otherContactMethod;
        private PhoneContact phoneContact;

        private void setContactListSelect(int choice) {
            if (contactListSelect == -1) {
                contactListSelect = choice;
            } else if (contactListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearContactListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearContactListSelect() {
            contactListSelect = -1;
        }

        /** 
         * Check if AddressContact is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAddressContact() {
            return contactListSelect == ADDRESS_CONTACT_CHOICE;
        }

        /** 
         * Get the 'AddressContact' element value.
         * 
         * @return value
         */
        public AddressContact getAddressContact() {
            return addressContact;
        }

        /** 
         * Set the 'AddressContact' element value.
         * 
         * @param addressContact
         */
        public void setAddressContact(AddressContact addressContact) {
            setContactListSelect(ADDRESS_CONTACT_CHOICE);
            this.addressContact = addressContact;
        }

        /** 
         * Check if EmailContact is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifEmailContact() {
            return contactListSelect == EMAIL_CONTACT_CHOICE;
        }

        /** 
         * Get the 'EmailContact' element value. Email address details, including application (I.e. home, business, etc.).
         * 
         * @return value
         */
        public EmailType getEmailContact() {
            return emailContact;
        }

        /** 
         * Set the 'EmailContact' element value. Email address details, including application (I.e. home, business, etc.).
         * 
         * @param emailContact
         */
        public void setEmailContact(EmailType emailContact) {
            setContactListSelect(EMAIL_CONTACT_CHOICE);
            this.emailContact = emailContact;
        }

        /** 
         * Check if OtherContactMethod is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOtherContactMethod() {
            return contactListSelect == OTHER_CONTACT_METHOD_CHOICE;
        }

        /** 
         * Get the 'OtherContactMethod' element value.
         * 
         * @return value
         */
        public OtherContactMethodType getOtherContactMethod() {
            return otherContactMethod;
        }

        /** 
         * Set the 'OtherContactMethod' element value.
         * 
         * @param otherContactMethod
         */
        public void setOtherContactMethod(
                OtherContactMethodType otherContactMethod) {
            setContactListSelect(OTHER_CONTACT_METHOD_CHOICE);
            this.otherContactMethod = otherContactMethod;
        }

        /** 
         * Check if PhoneContact is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPhoneContact() {
            return contactListSelect == PHONE_CONTACT_CHOICE;
        }

        /** 
         * Get the 'PhoneContact' element value.
         * 
         * @return value
         */
        public PhoneContact getPhoneContact() {
            return phoneContact;
        }

        /** 
         * Set the 'PhoneContact' element value.
         * 
         * @param phoneContact
         */
        public void setPhoneContact(PhoneContact phoneContact) {
            setContactListSelect(PHONE_CONTACT_CHOICE);
            this.phoneContact = phoneContact;
        }
    }
}
