
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for LANGUAGE Metadata.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LanguageMetadataType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="MetadataObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Code_ISO" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Code_NLS" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LanguageMetadataType extends MetadataObjectBaseType implements
    Serializable
{
    private String application;
    private String codeISO;
    private String codeNLS;
    private String name;

    /** 
     * Get the 'Application' element value. Language application.  Examples: Display, Requested, Spoken, Written
     * 
     * @return value
     */
    public String getApplication() {
        return application;
    }

    /** 
     * Set the 'Application' element value. Language application.  Examples: Display, Requested, Spoken, Written
     * 
     * @param application
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /** 
     * Get the 'Code_ISO' element value. Language encoding.  Examples: fr

    Encoding Scheme: ISO 639-1 Language Code
     * 
     * @return value
     */
    public String getCodeISO() {
        return codeISO;
    }

    /** 
     * Set the 'Code_ISO' element value. Language encoding.  Examples: fr

    Encoding Scheme: ISO 639-1 Language Code
     * 
     * @param codeISO
     */
    public void setCodeISO(String codeISO) {
        this.codeISO = codeISO;
    }

    /** 
     * Get the 'Code_NLS' element value. NLS Language encoding.  Examples: en-US

    Encoding Scheme: Microsoft National Language Support (NLS) Code
     * 
     * @return value
     */
    public String getCodeNLS() {
        return codeNLS;
    }

    /** 
     * Set the 'Code_NLS' element value. NLS Language encoding.  Examples: en-US

    Encoding Scheme: Microsoft National Language Support (NLS) Code
     * 
     * @param codeNLS
     */
    public void setCodeNLS(String codeNLS) {
        this.codeNLS = codeNLS;
    }

    /** 
     * Get the 'Name' element value. Language name. Example: English, United States
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Language name. Example: English, United States
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }
}
