
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * LEAD TIMES PERIOD helper object.

 Notes: Supports Calendar Shopping and Departure/ Arrival Time preferences.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LeadTimePeriodType">
 *   &lt;xs:attribute type="xs:string" use="optional" name="Before"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="After"/>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class LeadTimePeriodType implements Serializable
{
    private String before;
    private String after;
    private String refs;

    /** 
     * Get the 'Before' attribute value. The period duration to be applied BEFORE (prior to) the specified time.  Examples: 
    P3D (three days)
    PT2H (two hours)
     * 
     * @return value
     */
    public String getBefore() {
        return before;
    }

    /** 
     * Set the 'Before' attribute value. The period duration to be applied BEFORE (prior to) the specified time.  Examples: 
    P3D (three days)
    PT2H (two hours)
     * 
     * @param before
     */
    public void setBefore(String before) {
        this.before = before;
    }

    /** 
     * Get the 'After' attribute value. The period duration to be applied AFTER the specified time.  Examples: 
    P3D (three days)
    PT2H (two hours)
     * 
     * @return value
     */
    public String getAfter() {
        return after;
    }

    /** 
     * Set the 'After' attribute value. The period duration to be applied AFTER the specified time.  Examples: 
    P3D (three days)
    PT2H (two hours)
     * 
     * @param after
     */
    public void setAfter(String after) {
        this.after = after;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
