
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * OFFER/OFFER ITEM INSTRUCTIONS data list definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ListOfOfferInstructionsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Instruction" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Instruction -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ListOfOfferInstructionsType implements Serializable
{
    private List<Instruction> instructionList = new ArrayList<Instruction>();

    /** 
     * Get the list of 'Instruction' element items.
     * 
     * @return list
     */
    public List<Instruction> getInstructionList() {
        return instructionList;
    }

    /** 
     * Set the list of 'Instruction' element items.
     * 
     * @param list
     */
    public void setInstructionList(List<Instruction> list) {
        instructionList = list;
    }
    /** 
     * Offer Instruction detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Instruction" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="OfferInstructionType">
     *         &lt;xs:attributeGroup ref="DataListObjAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Instruction extends OfferInstructionType implements
        Serializable
    {
        private DataListObjAttrGroup dataListObjAttrGroup;

        /** 
         * Get the 'DataListObjAttrGroup' attributeGroup value.
         * 
         * @return value
         */
        public DataListObjAttrGroup getDataListObjAttrGroup() {
            return dataListObjAttrGroup;
        }

        /** 
         * Set the 'DataListObjAttrGroup' attributeGroup value.
         * 
         * @param dataListObjAttrGroup
         */
        public void setDataListObjAttrGroup(
                DataListObjAttrGroup dataListObjAttrGroup) {
            this.dataListObjAttrGroup = dataListObjAttrGroup;
        }
    }
}
