
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * 
 Examples: Imperial, Metric

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MeasurementTypeListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Imperial"/>
 *     &lt;xs:enumeration value="Metric"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum MeasurementTypeListType implements Serializable {
    IMPERIAL("Imperial"), METRIC("Metric");
    private final String value;

    private MeasurementTypeListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static MeasurementTypeListType convert(String value) {
        for (MeasurementTypeListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
