
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * Minimum Stay Requirement information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MinimumStay">
 *   &lt;xs:complexType>
 *     &lt;xs:choice>
 *       &lt;xs:element name="DayQuantity">
 *         &lt;xs:complexType>
 *           &lt;xs:simpleContent>
 *             &lt;xs:extension base="xs:string">
 *               &lt;xs:attribute type="xs:string" name="Context"/>
 *             &lt;/xs:extension>
 *           &lt;/xs:simpleContent>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element type="xs:string" name="DayOfWeek"/>
 *     &lt;/xs:choice>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class MinimumStay implements Serializable
{
    private int minimumStaySelect = -1;
    private static final int DAY_QUANTITY_CHOICE = 0;
    private static final int DAY_OF_WEEK_CHOICE = 1;
    private String dayQuantityString;
    private String dayQuantityContext;
    private String dayOfWeek;

    private void setMinimumStaySelect(int choice) {
        if (minimumStaySelect == -1) {
            minimumStaySelect = choice;
        } else if (minimumStaySelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearMinimumStaySelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearMinimumStaySelect() {
        minimumStaySelect = -1;
    }

    /** 
     * Check if DayQuantity is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDayQuantity() {
        return minimumStaySelect == DAY_QUANTITY_CHOICE;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getDayQuantityString() {
        return dayQuantityString;
    }

    /** 
     * Set the extension value.
     * 
     * @param dayQuantityString
     */
    public void setDayQuantityString(String dayQuantityString) {
        setMinimumStaySelect(DAY_QUANTITY_CHOICE);
        this.dayQuantityString = dayQuantityString;
    }

    /** 
     * Get the 'Context' attribute value. Restriction context. Example: EARLIEST, LATEST, Other
     * 
     * @return value
     */
    public String getDayQuantityContext() {
        return dayQuantityContext;
    }

    /** 
     * Set the 'Context' attribute value. Restriction context. Example: EARLIEST, LATEST, Other
     * 
     * @param dayQuantityContext
     */
    public void setDayQuantityContext(String dayQuantityContext) {
        setMinimumStaySelect(DAY_QUANTITY_CHOICE);
        this.dayQuantityContext = dayQuantityContext;
    }

    /** 
     * Check if DayOfWeek is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDayOfWeek() {
        return minimumStaySelect == DAY_OF_WEEK_CHOICE;
    }

    /** 
     * Get the 'DayOfWeek' element value. Minimum  stay represented as a week day number. Example: 1 (Monday)
     * 
     * @return value
     */
    public String getDayOfWeek() {
        return dayOfWeek;
    }

    /** 
     * Set the 'DayOfWeek' element value. Minimum  stay represented as a week day number. Example: 1 (Monday)
     * 
     * @param dayOfWeek
     */
    public void setDayOfWeek(String dayOfWeek) {
        setMinimumStaySelect(DAY_OF_WEEK_CHOICE);
        this.dayOfWeek = dayOfWeek;
    }
}
