
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Non Geographic Specification information
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NonGeographicSpecificationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:boolean" name="TravelAgencyInd" minOccurs="0"/>
 *     &lt;xs:element ref="AggregatorID" minOccurs="0"/>
 *     &lt;xs:element name="PointOfSaleCode" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class PointOfSaleCode -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class NonGeographicSpecificationType implements Serializable
{
    private Boolean travelAgencyInd;
    private AggregatorID aggregatorID;
    private List<PointOfSaleCode> pointOfSaleCodeList = new ArrayList<PointOfSaleCode>();

    /** 
     * Get the 'TravelAgencyInd' element value. Indicates whether a system may or may not send NDC requests based on whether the request is coming from a travel agency.                       
     * 
     * @return value
     */
    public Boolean getTravelAgencyInd() {
        return travelAgencyInd;
    }

    /** 
     * Set the 'TravelAgencyInd' element value. Indicates whether a system may or may not send NDC requests based on whether the request is coming from a travel agency.                       
     * 
     * @param travelAgencyInd
     */
    public void setTravelAgencyInd(Boolean travelAgencyInd) {
        this.travelAgencyInd = travelAgencyInd;
    }

    /** 
     * Get the 'AggregatorID' element value.
     * 
     * @return value
     */
    public AggregatorID getAggregatorID() {
        return aggregatorID;
    }

    /** 
     * Set the 'AggregatorID' element value.
     * 
     * @param aggregatorID
     */
    public void setAggregatorID(AggregatorID aggregatorID) {
        this.aggregatorID = aggregatorID;
    }

    /** 
     * Get the list of 'PointOfSaleCode' element items.
     * 
     * @return list
     */
    public List<PointOfSaleCode> getPointOfSaleCodeList() {
        return pointOfSaleCodeList;
    }

    /** 
     * Set the list of 'PointOfSaleCode' element items.
     * 
     * @param list
     */
    public void setPointOfSaleCodeList(List<PointOfSaleCode> list) {
        pointOfSaleCodeList = list;
    }
    /** 
     * Indicates whether a system may or may not send NDC requests based on whether the request is coming from a specific agency, department or CRT address.                       
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PointOfSaleCode" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute use="required" name="PointOfSaleType">
     *           &lt;xs:simpleType>
     *             &lt;!-- Reference to inner class PointOfSaleType -->
     *           &lt;/xs:simpleType>
     *         &lt;/xs:attribute>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PointOfSaleCode implements Serializable
    {
        private String string;
        private PointOfSaleType pointOfSaleType;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'PointOfSaleType' attribute value. Further defines the type of PointOfSaleCode                                                          Values include the following: T = Pseudo Code/Travel Agency Code                    I = IATA Travel Agency No.                                 H = Home IATA Agency No.                                 U = Home Travel Agency Code                                X = Department/Identifier    V = CRS/CXR Department Code                                L = LNIATA Number (CRT Address)                             A = Airline Specific Codes Blank = No application
         * 
         * @return value
         */
        public PointOfSaleType getPointOfSaleType() {
            return pointOfSaleType;
        }

        /** 
         * Set the 'PointOfSaleType' attribute value. Further defines the type of PointOfSaleCode                                                          Values include the following: T = Pseudo Code/Travel Agency Code                    I = IATA Travel Agency No.                                 H = Home IATA Agency No.                                 U = Home Travel Agency Code                                X = Department/Identifier    V = CRS/CXR Department Code                                L = LNIATA Number (CRT Address)                             A = Airline Specific Codes Blank = No application
         * 
         * @param pointOfSaleType
         */
        public void setPointOfSaleType(PointOfSaleType pointOfSaleType) {
            this.pointOfSaleType = pointOfSaleType;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="T"/>
         *     &lt;xs:enumeration value="I"/>
         *     &lt;xs:enumeration value="H"/>
         *     &lt;xs:enumeration value="U"/>
         *     &lt;xs:enumeration value="X"/>
         *     &lt;xs:enumeration value="V"/>
         *     &lt;xs:enumeration value="L"/>
         *     &lt;xs:enumeration value="A"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum PointOfSaleType implements Serializable {
            T, I, H, U, X, V, L, A
        }
    }
}
