
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * MINIMUM/ MAXIMUM Offer Ordering Quantity definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferOrderQuantityType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="xs:string" name="Minimum"/>
 *     &lt;xs:element type="xs:string" name="Maximum"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OfferOrderQuantityType implements Serializable
{
    private int choiceSelect = -1;
    private static final int MINIMUM_CHOICE = 0;
    private static final int MAXIMUM_CHOICE = 1;
    private String minimum;
    private String maximum;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Minimum is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMinimum() {
        return choiceSelect == MINIMUM_CHOICE;
    }

    /** 
     * Get the 'Minimum' element value. The MINIMUM Quantity of the Option that may be ordered. Example: 2
     * 
     * @return value
     */
    public String getMinimum() {
        return minimum;
    }

    /** 
     * Set the 'Minimum' element value. The MINIMUM Quantity of the Option that may be ordered. Example: 2
     * 
     * @param minimum
     */
    public void setMinimum(String minimum) {
        setChoiceSelect(MINIMUM_CHOICE);
        this.minimum = minimum;
    }

    /** 
     * Check if Maximum is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMaximum() {
        return choiceSelect == MAXIMUM_CHOICE;
    }

    /** 
     * Get the 'Maximum' element value. The MAXIMUM Quantity of the Option that may be ordered. Example: 4
     * 
     * @return value
     */
    public String getMaximum() {
        return maximum;
    }

    /** 
     * Set the 'Maximum' element value. The MAXIMUM Quantity of the Option that may be ordered. Example: 4
     * 
     * @param maximum
     */
    public void setMaximum(String maximum) {
        setChoiceSelect(MAXIMUM_CHOICE);
        this.maximum = maximum;
    }
}
