
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * LEAD PRICING CALENDAR Pricing definition.

 Price information for alternate dates.

 Notes:
 1. This is based on lead pricing specified in the AirShoppingRQ/ AttributeQuery/Flight node Arrival and/ or Departure elements.

 2. This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only.The technical implementation of this capability is not dictated by this specification.

 3. If implemented, the client application will typically send new a new shopping request if any of these window shopping dates are selected.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferPriceLeadType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="RequestedDate">
 *       &lt;xs:complexType>
 *         &lt;xs:complexContent>
 *           &lt;xs:extension base="OfferPriceLeadDetailType">
 *             &lt;xs:sequence>
 *               &lt;xs:element type="PricedFlightOfferAssocType" name="Associations" minOccurs="0" maxOccurs="unbounded"/>
 *             &lt;/xs:sequence>
 *           &lt;/xs:extension>
 *         &lt;/xs:complexContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element ref="FareDetail" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:anySimpleType" name="OfferItemID"/>
 *   &lt;xs:attribute type="xs:boolean" name="ModificationProhibitedInd"/>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class OfferPriceLeadType implements Serializable
{
    private OfferPriceLeadDetailType requestedDateOfferPriceLeadDetailType;
    private List<PricedFlightOfferAssocType> requestedDateAssociationList = new ArrayList<PricedFlightOfferAssocType>();
    private FareDetailType fareDetail;
    private String offerItemID;
    private Boolean modificationProhibitedInd;
    private String refs;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public OfferPriceLeadDetailType getRequestedDateOfferPriceLeadDetailType() {
        return requestedDateOfferPriceLeadDetailType;
    }

    /** 
     * Set the extension value.
     * 
     * @param requestedDateOfferPriceLeadDetailType
     */
    public void setRequestedDateOfferPriceLeadDetailType(
            OfferPriceLeadDetailType requestedDateOfferPriceLeadDetailType) {
        this.requestedDateOfferPriceLeadDetailType = requestedDateOfferPriceLeadDetailType;
    }

    /** 
     * Get the list of 'Associations' element items. Fare Offer Associations.
     * 
     * @return list
     */
    public List<PricedFlightOfferAssocType> getRequestedDateAssociationList() {
        return requestedDateAssociationList;
    }

    /** 
     * Set the list of 'Associations' element items. Fare Offer Associations.
     * 
     * @param list
     */
    public void setRequestedDateAssociationList(
            List<PricedFlightOfferAssocType> list) {
        requestedDateAssociationList = list;
    }

    /** 
     * Get the 'FareDetail' element value.
     * 
     * @return value
     */
    public FareDetailType getFareDetail() {
        return fareDetail;
    }

    /** 
     * Set the 'FareDetail' element value.
     * 
     * @param fareDetail
     */
    public void setFareDetail(FareDetailType fareDetail) {
        this.fareDetail = fareDetail;
    }

    /** 
     * Get the 'OfferItemID' attribute value. Globally unique OfferItem instance ID. It is not recommended to exceed 64, and it is not recommended to use dashes..Example: QWASZXERDFCVTYGHBNUIJKNMF67D5F9GHR567SWER41SD458F9456FMDIRTN34DF
     * 
     * @return value
     */
    public String getOfferItemID() {
        return offerItemID;
    }

    /** 
     * Set the 'OfferItemID' attribute value. Globally unique OfferItem instance ID. It is not recommended to exceed 64, and it is not recommended to use dashes..Example: QWASZXERDFCVTYGHBNUIJKNMF67D5F9GHR567SWER41SD458F9456FMDIRTN34DF
     * 
     * @param offerItemID
     */
    public void setOfferItemID(String offerItemID) {
        this.offerItemID = offerItemID;
    }

    /** 
     * Get the 'ModificationProhibitedInd' attribute value. POA to ORA only: to indicate that the offer is non-modifiable. This indicates to ORA that its offer is non-modifiable (eg. Regulatory or brand protection reasons). If indicator is set to true, nodifications to the POA’s offer ARE NOT allowed.
     * 
     * @return value
     */
    public Boolean getModificationProhibitedInd() {
        return modificationProhibitedInd;
    }

    /** 
     * Set the 'ModificationProhibitedInd' attribute value. POA to ORA only: to indicate that the offer is non-modifiable. This indicates to ORA that its offer is non-modifiable (eg. Regulatory or brand protection reasons). If indicator is set to true, nodifications to the POA’s offer ARE NOT allowed.
     * 
     * @param modificationProhibitedInd
     */
    public void setModificationProhibitedInd(Boolean modificationProhibitedInd) {
        this.modificationProhibitedInd = modificationProhibitedInd;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
