
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * OFFER TERMS definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferTermsType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="OfferValidPeriodType" name="AvailablePeriod"/>
 *     &lt;xs:element type="Descriptions" name="Descriptions"/>
 *     &lt;xs:element type="OfferGroupSizeType" name="GroupSize"/>
 *     &lt;xs:element type="OfferOrderQuantityType" name="OrderingQuantity"/>
 *   &lt;/xs:choice>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class OfferTermsType implements Serializable
{
    private int choiceSelect = -1;
    private static final int AVAILABLE_PERIOD_CHOICE = 0;
    private static final int DESCRIPTIONS_CHOICE = 1;
    private static final int GROUP_SIZE_CHOICE = 2;
    private static final int ORDERING_QUANTITY_CHOICE = 3;
    private OfferValidPeriodType availablePeriod;
    private Descriptions descriptions;
    private OfferGroupSizeType groupSize;
    private OfferOrderQuantityType orderingQuantity;
    private String refs;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if AvailablePeriod is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAvailablePeriod() {
        return choiceSelect == AVAILABLE_PERIOD_CHOICE;
    }

    /** 
     * Get the 'AvailablePeriod' element value. Earliest and Latest Period that an Option is Available or May be Used.
     * 
     * @return value
     */
    public OfferValidPeriodType getAvailablePeriod() {
        return availablePeriod;
    }

    /** 
     * Set the 'AvailablePeriod' element value. Earliest and Latest Period that an Option is Available or May be Used.
     * 
     * @param availablePeriod
     */
    public void setAvailablePeriod(OfferValidPeriodType availablePeriod) {
        setChoiceSelect(AVAILABLE_PERIOD_CHOICE);
        this.availablePeriod = availablePeriod;
    }

    /** 
     * Check if Descriptions is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDescriptions() {
        return choiceSelect == DESCRIPTIONS_CHOICE;
    }

    /** 
     * Get the 'Descriptions' element value. Offer Terms Description(s).
     * 
     * @return value
     */
    public Descriptions getDescriptions() {
        return descriptions;
    }

    /** 
     * Set the 'Descriptions' element value. Offer Terms Description(s).
     * 
     * @param descriptions
     */
    public void setDescriptions(Descriptions descriptions) {
        setChoiceSelect(DESCRIPTIONS_CHOICE);
        this.descriptions = descriptions;
    }

    /** 
     * Check if GroupSize is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifGroupSize() {
        return choiceSelect == GROUP_SIZE_CHOICE;
    }

    /** 
     * Get the 'GroupSize' element value. Minimum and Maximum Group Size, e.g. Traveler quantities, associated with the Offer.
     * 
     * @return value
     */
    public OfferGroupSizeType getGroupSize() {
        return groupSize;
    }

    /** 
     * Set the 'GroupSize' element value. Minimum and Maximum Group Size, e.g. Traveler quantities, associated with the Offer.
     * 
     * @param groupSize
     */
    public void setGroupSize(OfferGroupSizeType groupSize) {
        setChoiceSelect(GROUP_SIZE_CHOICE);
        this.groupSize = groupSize;
    }

    /** 
     * Check if OrderingQuantity is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOrderingQuantity() {
        return choiceSelect == ORDERING_QUANTITY_CHOICE;
    }

    /** 
     * Get the 'OrderingQuantity' element value. Minimum/ Maximum Option Ordering Quantity(s).
     * 
     * @return value
     */
    public OfferOrderQuantityType getOrderingQuantity() {
        return orderingQuantity;
    }

    /** 
     * Set the 'OrderingQuantity' element value. Minimum/ Maximum Option Ordering Quantity(s).
     * 
     * @param orderingQuantity
     */
    public void setOrderingQuantity(OfferOrderQuantityType orderingQuantity) {
        setChoiceSelect(ORDERING_QUANTITY_CHOICE);
        this.orderingQuantity = orderingQuantity;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
