
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Offer definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Parameters" minOccurs="0">
 *       &lt;!-- Reference to inner class Parameters -->
 *     &lt;/xs:element>
 *     &lt;xs:element ref="ValidatingCarrier" minOccurs="0"/>
 *     &lt;xs:element type="OfferTimeLimitSetType" name="TimeLimits" minOccurs="0"/>
 *     &lt;xs:element name="TotalPrice" minOccurs="0">
 *       &lt;!-- Reference to inner class TotalPrice -->
 *     &lt;/xs:element>
 *     &lt;xs:element ref="DescriptionReferences" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DisclosureRef" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BagDisclosureRefs" minOccurs="0"/>
 *     &lt;xs:element type="PenaltyType" name="Penalty" minOccurs="0"/>
 *     &lt;xs:element ref="Match" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="OfferID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="Owner"/>
 *   &lt;xs:attribute type="xs:string" name="OwnerType"/>
 *   &lt;xs:attribute type="xs:boolean" name="RequestedDateInd"/>
 *   &lt;xs:attribute type="xs:string" name="WebAddressID"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OfferType implements Serializable
{
    private Parameters parameters;
    private ValidatingCarrier validatingCarrier;
    private OfferTimeLimitSetType timeLimits;
    private TotalPrice totalPrice;
    private DescriptionReferences descriptionReferences;
    private String disclosureRef;
    private String bagDisclosureRefs;
    private PenaltyType penalty;
    private OfferMatchType match;
    private String offerID;
    private String owner;
    private String ownerType;
    private Boolean requestedDateInd;
    private String webAddressID;

    /** 
     * Get the 'Parameters' element value.
     * 
     * @return value
     */
    public Parameters getParameters() {
        return parameters;
    }

    /** 
     * Set the 'Parameters' element value.
     * 
     * @param parameters
     */
    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    /** 
     * Get the 'ValidatingCarrier' element value.
     * 
     * @return value
     */
    public ValidatingCarrier getValidatingCarrier() {
        return validatingCarrier;
    }

    /** 
     * Set the 'ValidatingCarrier' element value.
     * 
     * @param validatingCarrier
     */
    public void setValidatingCarrier(ValidatingCarrier validatingCarrier) {
        this.validatingCarrier = validatingCarrier;
    }

    /** 
     * Get the 'TimeLimits' element value. Offer-Level Time Limits, including Offer Expiration, Payment and Bilateral Time Limits.

    Note: If specified, these time limits are at the OFFER-LEVEL and will apply by default to any relevant (child) Offer Items. These time limits may also be specified at a (child) OFFER ITEM-level where it will apply to that one instance of the Offer Item (and override the Offer-level time limit if one has been specified.)
     * 
     * @return value
     */
    public OfferTimeLimitSetType getTimeLimits() {
        return timeLimits;
    }

    /** 
     * Set the 'TimeLimits' element value. Offer-Level Time Limits, including Offer Expiration, Payment and Bilateral Time Limits.

    Note: If specified, these time limits are at the OFFER-LEVEL and will apply by default to any relevant (child) Offer Items. These time limits may also be specified at a (child) OFFER ITEM-level where it will apply to that one instance of the Offer Item (and override the Offer-level time limit if one has been specified.)
     * 
     * @param timeLimits
     */
    public void setTimeLimits(OfferTimeLimitSetType timeLimits) {
        this.timeLimits = timeLimits;
    }

    /** 
     * Get the 'TotalPrice' element value.
     * 
     * @return value
     */
    public TotalPrice getTotalPrice() {
        return totalPrice;
    }

    /** 
     * Set the 'TotalPrice' element value.
     * 
     * @param totalPrice
     */
    public void setTotalPrice(TotalPrice totalPrice) {
        this.totalPrice = totalPrice;
    }

    /** 
     * Get the 'DescriptionReferences' element value.
     * 
     * @return value
     */
    public DescriptionReferences getDescriptionReferences() {
        return descriptionReferences;
    }

    /** 
     * Set the 'DescriptionReferences' element value.
     * 
     * @param descriptionReferences
     */
    public void setDescriptionReferences(
            DescriptionReferences descriptionReferences) {
        this.descriptionReferences = descriptionReferences;
    }

    /** 
     * Get the 'DisclosureRef' element value.
     * 
     * @return value
     */
    public String getDisclosureRef() {
        return disclosureRef;
    }

    /** 
     * Set the 'DisclosureRef' element value.
     * 
     * @param disclosureRef
     */
    public void setDisclosureRef(String disclosureRef) {
        this.disclosureRef = disclosureRef;
    }

    /** 
     * Get the 'BagDisclosureRefs' element value.
     * 
     * @return value
     */
    public String getBagDisclosureRefs() {
        return bagDisclosureRefs;
    }

    /** 
     * Set the 'BagDisclosureRefs' element value.
     * 
     * @param bagDisclosureRefs
     */
    public void setBagDisclosureRefs(String bagDisclosureRefs) {
        this.bagDisclosureRefs = bagDisclosureRefs;
    }

    /** 
     * Get the 'Penalty' element value. Penalty information.
     * 
     * @return value
     */
    public PenaltyType getPenalty() {
        return penalty;
    }

    /** 
     * Set the 'Penalty' element value. Penalty information.
     * 
     * @param penalty
     */
    public void setPenalty(PenaltyType penalty) {
        this.penalty = penalty;
    }

    /** 
     * Get the 'Match' element value.
     * 
     * @return value
     */
    public OfferMatchType getMatch() {
        return match;
    }

    /** 
     * Set the 'Match' element value.
     * 
     * @param match
     */
    public void setMatch(OfferMatchType match) {
        this.match = match;
    }

    /** 
     * Get the 'OfferID' attribute value. Airline-assigned unique Offer identifier.
     * 
     * @return value
     */
    public String getOfferID() {
        return offerID;
    }

    /** 
     * Set the 'OfferID' attribute value. Airline-assigned unique Offer identifier.
     * 
     * @param offerID
     */
    public void setOfferID(String offerID) {
        this.offerID = offerID;
    }

    /** 
     * Get the 'Owner' attribute value. Airline designator of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
     * 
     * @return value
     */
    public String getOwner() {
        return owner;
    }

    /** 
     * Set the 'Owner' attribute value. Airline designator of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
     * 
     * @param owner
     */
    public void setOwner(String owner) {
        this.owner = owner;
    }

    /** 
     * Get the 'OwnerType' attribute value. The POA OrderID should only go to the ORA, not back to the seller.
    1. ORA
    2. POA
     * 
     * @return value
     */
    public String getOwnerType() {
        return ownerType;
    }

    /** 
     * Set the 'OwnerType' attribute value. The POA OrderID should only go to the ORA, not back to the seller.
    1. ORA
    2. POA
     * 
     * @param ownerType
     */
    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    /** 
     * Get the 'RequestedDateInd' attribute value. Indicator to specify if the offer relates to requested date. For example in calendar search, this indicator will be set to 'true' if this airline offer is for a requested date and will not be present (or will be set to 'false' if airline offer is for another date than requested one.
     * 
     * @return value
     */
    public Boolean getRequestedDateInd() {
        return requestedDateInd;
    }

    /** 
     * Set the 'RequestedDateInd' attribute value. Indicator to specify if the offer relates to requested date. For example in calendar search, this indicator will be set to 'true' if this airline offer is for a requested date and will not be present (or will be set to 'false' if airline offer is for another date than requested one.
     * 
     * @param requestedDateInd
     */
    public void setRequestedDateInd(Boolean requestedDateInd) {
        this.requestedDateInd = requestedDateInd;
    }

    /** 
     * Get the 'WebAddressID' attribute value. Deep linking into another site to complete the transaction. 
     * 
     * @return value
     */
    public String getWebAddressID() {
        return webAddressID;
    }

    /** 
     * Set the 'WebAddressID' attribute value. Deep linking into another site to complete the transaction. 
     * 
     * @param webAddressID
     */
    public void setWebAddressID(String webAddressID) {
        this.webAddressID = webAddressID;
    }
    /** 
     * Offer-wide parameters, including Traveler Applicability; Total Offer Quantity; Passenger Pricing Method; Inventory Guarantee.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Parameters" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="TotalItemQuantity" minOccurs="0"/>
     *       &lt;xs:element ref="PTC_Priced" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="ApplyToAllInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="RedemptionOnlyInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Parameters implements Serializable
    {
        private String totalItemQuantity;
        private List<PTCQuantityPricedType> PTCPricedList = new ArrayList<PTCQuantityPricedType>();
        private Boolean applyToAllInd;
        private Boolean redemptionOnlyInd;

        /** 
         * Get the 'TotalItemQuantity' element value. Total Offer Items in this Offer. Example: 3
         * 
         * @return value
         */
        public String getTotalItemQuantity() {
            return totalItemQuantity;
        }

        /** 
         * Set the 'TotalItemQuantity' element value. Total Offer Items in this Offer. Example: 3
         * 
         * @param totalItemQuantity
         */
        public void setTotalItemQuantity(String totalItemQuantity) {
            this.totalItemQuantity = totalItemQuantity;
        }

        /** 
         * Get the list of 'PTC_Priced' element items. Requested and Priced PTC (passenger type code) and associated Traveler quantity.
         * 
         * @return list
         */
        public List<PTCQuantityPricedType> getPTCPricedList() {
            return PTCPricedList;
        }

        /** 
         * Set the list of 'PTC_Priced' element items. Requested and Priced PTC (passenger type code) and associated Traveler quantity.
         * 
         * @param list
         */
        public void setPTCPricedList(List<PTCQuantityPricedType> list) {
            PTCPricedList = list;
        }

        /** 
         * Get the 'ApplyToAllInd' attribute value. When true, this Offer applies to all Travelers.
         * 
         * @return value
         */
        public Boolean getApplyToAllInd() {
            return applyToAllInd;
        }

        /** 
         * Set the 'ApplyToAllInd' attribute value. When true, this Offer applies to all Travelers.
         * 
         * @param applyToAllInd
         */
        public void setApplyToAllInd(Boolean applyToAllInd) {
            this.applyToAllInd = applyToAllInd;
        }

        /** 
         * Get the 'RedemptionOnlyInd' attribute value. When true, this Offer must be redeemed, e.g. it cannot be purchased.

        Note: Taxes may still apply.
         * 
         * @return value
         */
        public Boolean getRedemptionOnlyInd() {
            return redemptionOnlyInd;
        }

        /** 
         * Set the 'RedemptionOnlyInd' attribute value. When true, this Offer must be redeemed, e.g. it cannot be purchased.

        Note: Taxes may still apply.
         * 
         * @param redemptionOnlyInd
         */
        public void setRedemptionOnlyInd(Boolean redemptionOnlyInd) {
            this.redemptionOnlyInd = redemptionOnlyInd;
        }
    }
    /** 
     * The total price for all mandatory OfferItems contained within this Offer.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalPrice" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="AwardPricing"/>
     *       &lt;xs:element ref="CombinationPricing"/>
     *       &lt;xs:element ref="SimpleCurrencyPrice"/>
     *       &lt;xs:element ref="DetailCurrencyPrice"/>
     *       &lt;xs:element ref="EncodedCurrencyPrice"/>
     *     &lt;/xs:choice>
     *     &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class TotalPrice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int AWARD_PRICING_CHOICE = 0;
        private static final int COMBINATION_PRICING_CHOICE = 1;
        private static final int SIMPLE_CURRENCY_PRICE_CHOICE = 2;
        private static final int DETAIL_CURRENCY_PRICE_CHOICE = 3;
        private static final int ENCODED_CURRENCY_PRICE_CHOICE = 4;
        private AwardPriceUnitType awardPricing;
        private CombinationPriceType combinationPricing;
        private SimpleCurrencyPrice simpleCurrencyPrice;
        private DetailCurrencyPriceType detailCurrencyPrice;
        private EncodedCurrencyPrice encodedCurrencyPrice;
        private String refs;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if AwardPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAwardPricing() {
            return choiceSelect == AWARD_PRICING_CHOICE;
        }

        /** 
         * Get the 'AwardPricing' element value.
         * 
         * @return value
         */
        public AwardPriceUnitType getAwardPricing() {
            return awardPricing;
        }

        /** 
         * Set the 'AwardPricing' element value.
         * 
         * @param awardPricing
         */
        public void setAwardPricing(AwardPriceUnitType awardPricing) {
            setChoiceSelect(AWARD_PRICING_CHOICE);
            this.awardPricing = awardPricing;
        }

        /** 
         * Check if CombinationPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCombinationPricing() {
            return choiceSelect == COMBINATION_PRICING_CHOICE;
        }

        /** 
         * Get the 'CombinationPricing' element value.
         * 
         * @return value
         */
        public CombinationPriceType getCombinationPricing() {
            return combinationPricing;
        }

        /** 
         * Set the 'CombinationPricing' element value.
         * 
         * @param combinationPricing
         */
        public void setCombinationPricing(
                CombinationPriceType combinationPricing) {
            setChoiceSelect(COMBINATION_PRICING_CHOICE);
            this.combinationPricing = combinationPricing;
        }

        /** 
         * Check if SimpleCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSimpleCurrencyPrice() {
            return choiceSelect == SIMPLE_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'SimpleCurrencyPrice' element value.
         * 
         * @return value
         */
        public SimpleCurrencyPrice getSimpleCurrencyPrice() {
            return simpleCurrencyPrice;
        }

        /** 
         * Set the 'SimpleCurrencyPrice' element value.
         * 
         * @param simpleCurrencyPrice
         */
        public void setSimpleCurrencyPrice(
                SimpleCurrencyPrice simpleCurrencyPrice) {
            setChoiceSelect(SIMPLE_CURRENCY_PRICE_CHOICE);
            this.simpleCurrencyPrice = simpleCurrencyPrice;
        }

        /** 
         * Check if DetailCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifDetailCurrencyPrice() {
            return choiceSelect == DETAIL_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'DetailCurrencyPrice' element value.
         * 
         * @return value
         */
        public DetailCurrencyPriceType getDetailCurrencyPrice() {
            return detailCurrencyPrice;
        }

        /** 
         * Set the 'DetailCurrencyPrice' element value.
         * 
         * @param detailCurrencyPrice
         */
        public void setDetailCurrencyPrice(
                DetailCurrencyPriceType detailCurrencyPrice) {
            setChoiceSelect(DETAIL_CURRENCY_PRICE_CHOICE);
            this.detailCurrencyPrice = detailCurrencyPrice;
        }

        /** 
         * Check if EncodedCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifEncodedCurrencyPrice() {
            return choiceSelect == ENCODED_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'EncodedCurrencyPrice' element value.
         * 
         * @return value
         */
        public EncodedCurrencyPrice getEncodedCurrencyPrice() {
            return encodedCurrencyPrice;
        }

        /** 
         * Set the 'EncodedCurrencyPrice' element value.
         * 
         * @param encodedCurrencyPrice
         */
        public void setEncodedCurrencyPrice(
                EncodedCurrencyPrice encodedCurrencyPrice) {
            setChoiceSelect(ENCODED_CURRENCY_PRICE_CHOICE);
            this.encodedCurrencyPrice = encodedCurrencyPrice;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
