
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * EARLIEST/LATEST Option Available/ Use definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferValidPeriodType">
 *   &lt;xs:choice maxOccurs="2">
 *     &lt;!-- Reference to inner class Choice -->
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OfferValidPeriodType implements Serializable
{
    private List<Choice> choiceList = new ArrayList<Choice>();

    /** 
     * Get the list of 'OfferValidPeriodType' complexType items.
     * 
     * @return list
     */
    public List<Choice> getChoiceList() {
        return choiceList;
    }

    /** 
     * Set the list of 'OfferValidPeriodType' complexType items.
     * 
     * @param list
     */
    public void setChoiceList(List<Choice> list) {
        choiceList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="2">
     *   &lt;xs:element type="CoreDateGrpType" name="Earliest"/>
     *   &lt;xs:element type="CoreDateGrpType" name="Latest"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceListSelect = -1;
        private static final int EARLIEST_CHOICE = 0;
        private static final int LATEST_CHOICE = 1;
        private CoreDateGrpType earliest;
        private CoreDateGrpType latest;

        private void setChoiceListSelect(int choice) {
            if (choiceListSelect == -1) {
                choiceListSelect = choice;
            } else if (choiceListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceListSelect() {
            choiceListSelect = -1;
        }

        /** 
         * Check if Earliest is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifEarliest() {
            return choiceListSelect == EARLIEST_CHOICE;
        }

        /** 
         * Get the 'Earliest' element value. Offer/ Order term (condition) for the Earliest time an item is Available or May be Used.

        Examples: 2017-01-03T13:20:00, 2017-01-13T13:59:38Z
         * 
         * @return value
         */
        public CoreDateGrpType getEarliest() {
            return earliest;
        }

        /** 
         * Set the 'Earliest' element value. Offer/ Order term (condition) for the Earliest time an item is Available or May be Used.

        Examples: 2017-01-03T13:20:00, 2017-01-13T13:59:38Z
         * 
         * @param earliest
         */
        public void setEarliest(CoreDateGrpType earliest) {
            setChoiceListSelect(EARLIEST_CHOICE);
            this.earliest = earliest;
        }

        /** 
         * Check if Latest is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifLatest() {
            return choiceListSelect == LATEST_CHOICE;
        }

        /** 
         * Get the 'Latest' element value. Offer/ Order term (condition) for the Latest time an item is Available or May be Used.

        Examples: 2017-01-03T13:20:00, 2017-01-13T13:59:38Z
         * 
         * @return value
         */
        public CoreDateGrpType getLatest() {
            return latest;
        }

        /** 
         * Set the 'Latest' element value. Offer/ Order term (condition) for the Latest time an item is Available or May be Used.

        Examples: 2017-01-03T13:20:00, 2017-01-13T13:59:38Z
         * 
         * @param latest
         */
        public void setLatest(CoreDateGrpType latest) {
            setChoiceListSelect(LATEST_CHOICE);
            this.latest = latest;
        }
    }
}
