
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferedServiceType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Transportation"/>
 *     &lt;xs:enumeration value="Baggage"/>
 *     &lt;xs:enumeration value="Seats"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum OfferedServiceType implements Serializable {
    TRANSPORTATION("Transportation"), BAGGAGE("Baggage"), SEATS("Seats"), OTHER(
            "Other");
    private final String value;

    private OfferedServiceType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static OfferedServiceType convert(String value) {
        for (OfferedServiceType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
