
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * 
 A data type for an Order Action list constraint. Examples: Cancel, Create, Divide, Delete, Reissue, Reprice, Update

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderItemActionSimpleType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Cancel"/>
 *     &lt;xs:enumeration value="Create"/>
 *     &lt;xs:enumeration value="Delete"/>
 *     &lt;xs:enumeration value="Divide"/>
 *     &lt;xs:enumeration value="Reissue"/>
 *     &lt;xs:enumeration value="Reprice"/>
 *     &lt;xs:enumeration value="Update"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum OrderItemActionSimpleType implements Serializable {
    CANCEL("Cancel"), CREATE("Create"), DELETE("Delete"), DIVIDE("Divide"), REISSUE(
            "Reissue"), REPRICE("Reprice"), UPDATE("Update");
    private final String value;

    private OrderItemActionSimpleType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static OrderItemActionSimpleType convert(String value) {
        for (OrderItemActionSimpleType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
