
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Additional Order Item Details, including instructions.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderItemDetails">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="OrderItemDetail" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class OrderItemDetail -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="SettlementType" name="OrderItemSettlement" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OrderItemDetails implements Serializable
{
    private List<OrderItemDetail> orderItemDetailList = new ArrayList<OrderItemDetail>();
    private SettlementType orderItemSettlement;

    /** 
     * Get the list of 'OrderItemDetail' element items.
     * 
     * @return list
     */
    public List<OrderItemDetail> getOrderItemDetailList() {
        return orderItemDetailList;
    }

    /** 
     * Set the list of 'OrderItemDetail' element items.
     * 
     * @param list
     */
    public void setOrderItemDetailList(List<OrderItemDetail> list) {
        orderItemDetailList = list;
    }

    /** 
     * Get the 'OrderItemSettlement' element value.
     * 
     * @return value
     */
    public SettlementType getOrderItemSettlement() {
        return orderItemSettlement;
    }

    /** 
     * Set the 'OrderItemSettlement' element value.
     * 
     * @param orderItemSettlement
     */
    public void setOrderItemSettlement(SettlementType orderItemSettlement) {
        this.orderItemSettlement = orderItemSettlement;
    }
    /** 
     * Order detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderItemDetail" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="OrderCommision"/>
     *       &lt;xs:element ref="OrderInstructions"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OrderItemDetail implements Serializable
    {
        private int orderItemDetailListSelect = -1;
        private static final int ORDER_COMMISION_CHOICE = 0;
        private static final int ORDER_INSTRUCTIONS_CHOICE = 1;
        private OrderCommision orderCommision;
        private OrderInstructions orderInstructions;

        private void setOrderItemDetailListSelect(int choice) {
            if (orderItemDetailListSelect == -1) {
                orderItemDetailListSelect = choice;
            } else if (orderItemDetailListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearOrderItemDetailListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearOrderItemDetailListSelect() {
            orderItemDetailListSelect = -1;
        }

        /** 
         * Check if OrderCommision is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOrderCommision() {
            return orderItemDetailListSelect == ORDER_COMMISION_CHOICE;
        }

        /** 
         * Get the 'OrderCommision' element value. Details of the commission claimed by a Travel Agent for selling air transportation/services on behalf of an airline.
         * 
         * @return value
         */
        public OrderCommision getOrderCommision() {
            return orderCommision;
        }

        /** 
         * Set the 'OrderCommision' element value. Details of the commission claimed by a Travel Agent for selling air transportation/services on behalf of an airline.
         * 
         * @param orderCommision
         */
        public void setOrderCommision(OrderCommision orderCommision) {
            setOrderItemDetailListSelect(ORDER_COMMISION_CHOICE);
            this.orderCommision = orderCommision;
        }

        /** 
         * Check if OrderInstructions is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOrderInstructions() {
            return orderItemDetailListSelect == ORDER_INSTRUCTIONS_CHOICE;
        }

        /** 
         * Get the 'OrderInstructions' element value.
         * 
         * @return value
         */
        public OrderInstructions getOrderInstructions() {
            return orderInstructions;
        }

        /** 
         * Set the 'OrderInstructions' element value.
         * 
         * @param orderInstructions
         */
        public void setOrderInstructions(OrderInstructions orderInstructions) {
            setOrderItemDetailListSelect(ORDER_INSTRUCTIONS_CHOICE);
            this.orderInstructions = orderInstructions;
        }
    }
}
