
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

/** 
 * CORE ORDER ITEM definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="OrderItem" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class OrderItem -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrderItemType implements Serializable
{
    private List<OrderItem> orderItemList = new ArrayList<OrderItem>();

    /** 
     * Get the list of 'OrderItem' element items.
     * 
     * @return list
     */
    public List<OrderItem> getOrderItemList() {
        return orderItemList;
    }

    /** 
     * Set the list of 'OrderItem' element items.
     * 
     * @param list
     */
    public void setOrderItemList(List<OrderItem> list) {
        orderItemList = list;
    }
    /** 
     * Order Item details.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderItem" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ItemStatus" minOccurs="0"/>
     *       &lt;xs:element name="PriceDetail">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element name="TotalAmount" minOccurs="0">
     *               &lt;!-- Reference to inner class TotalAmount -->
     *             &lt;/xs:element>
     *             &lt;xs:element type="CurrencyAmountOptType" name="BaseAmount"/>
     *             &lt;xs:element ref="FareFiledIn" minOccurs="0"/>
     *             &lt;xs:element type="DiscountType" name="Discount" minOccurs="0"/>
     *             &lt;xs:element name="Surcharges" minOccurs="0">
     *               &lt;!-- Reference to inner class Surcharges -->
     *             &lt;/xs:element>
     *             &lt;xs:element type="TaxDetailType" name="Taxes" minOccurs="0"/>
     *             &lt;xs:element ref="TaxExemption" minOccurs="0"/>
     *             &lt;xs:choice>
     *               &lt;xs:element type="AwardPriceUnitType" name="AwardPricing" minOccurs="0"/>
     *               &lt;xs:element type="CombinationPriceType" name="CombinationPricing" minOccurs="0"/>
     *             &lt;/xs:choice>
     *             &lt;xs:element type="FeeSurchargeType" name="Fees" minOccurs="0"/>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="Service" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Service -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="OrderItemTimeLimitsType" name="TimeLimits" minOccurs="0"/>
     *       &lt;xs:element name="InventoryGuarantee" minOccurs="0">
     *         &lt;!-- Reference to inner class InventoryGuarantee -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="Disclosures" minOccurs="0"/>
     *       &lt;xs:element type="PenaltyType" name="Penalty" minOccurs="0"/>
     *       &lt;xs:element ref="OrderItemDetails" minOccurs="0"/>
     *       &lt;xs:element type="FareDetailType" name="FareDetail" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="required" name="OrderItemID"/>
     *     &lt;xs:attribute type="xs:string" name="Owner"/>
     *     &lt;xs:attribute type="xs:string" name="OwnerType"/>
     *     &lt;xs:attribute type="xs:dateTime" use="optional" name="Timestamp"/>
     *     &lt;xs:attribute type="xs:string" name="WebAddressID"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OrderItem implements Serializable
    {
        private ItemStatus itemStatus;
        private TotalAmount totalAmount;
        private CurrencyAmountOptType priceDetailBaseAmount;
        private FareFilingType priceDetailFareFiledIn;
        private DiscountType priceDetailDiscount;
        private Surcharges surcharges;
        private TaxDetailType priceDetailTaxes;
        private TaxExemptionType priceDetailTaxExemption;
        private int priceDetailChoiceSelect = -1;
        private static final int PRICE_DETAIL_AWARD_PRICING_CHOICE = 0;
        private static final int PRICE_DETAIL_COMBINATION_PRICING_CHOICE = 1;
        private AwardPriceUnitType priceDetailAwardPricing;
        private CombinationPriceType priceDetailCombinationPricing;
        private FeeSurchargeType priceDetailFees;
        private List<Service> serviceList = new ArrayList<Service>();
        private OrderItemTimeLimitsType timeLimits;
        private InventoryGuarantee inventoryGuarantee;
        private DisclosureType disclosures;
        private PenaltyType penalty;
        private OrderItemDetails orderItemDetails;
        private List<FareDetailType> fareDetailList = new ArrayList<FareDetailType>();
        private String orderItemID;
        private String owner;
        private String ownerType;
        private DateTime timestamp;
        private String webAddressID;

        /** 
         * Get the 'ItemStatus' element value. Current Order Item status. Example: OK (Confirmed) Encoding Scheme: IATA Padis Codeset - List for data element 4405 (Status, coded)
         * 
         * @return value
         */
        public ItemStatus getItemStatus() {
            return itemStatus;
        }

        /** 
         * Set the 'ItemStatus' element value. Current Order Item status. Example: OK (Confirmed) Encoding Scheme: IATA Padis Codeset - List for data element 4405 (Status, coded)
         * 
         * @param itemStatus
         */
        public void setItemStatus(ItemStatus itemStatus) {
            this.itemStatus = itemStatus;
        }

        /** 
         * Get the 'TotalAmount' element value.
         * 
         * @return value
         */
        public TotalAmount getTotalAmount() {
            return totalAmount;
        }

        /** 
         * Set the 'TotalAmount' element value.
         * 
         * @param totalAmount
         */
        public void setTotalAmount(TotalAmount totalAmount) {
            this.totalAmount = totalAmount;
        }

        /** 
         * Get the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

        Note: This includes  surcharges (if applicable).
         * 
         * @return value
         */
        public CurrencyAmountOptType getPriceDetailBaseAmount() {
            return priceDetailBaseAmount;
        }

        /** 
         * Set the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

        Note: This includes  surcharges (if applicable).
         * 
         * @param priceDetailBaseAmount
         */
        public void setPriceDetailBaseAmount(
                CurrencyAmountOptType priceDetailBaseAmount) {
            this.priceDetailBaseAmount = priceDetailBaseAmount;
        }

        /** 
         * Get the 'FareFiledIn' element value.
         * 
         * @return value
         */
        public FareFilingType getPriceDetailFareFiledIn() {
            return priceDetailFareFiledIn;
        }

        /** 
         * Set the 'FareFiledIn' element value.
         * 
         * @param priceDetailFareFiledIn
         */
        public void setPriceDetailFareFiledIn(
                FareFilingType priceDetailFareFiledIn) {
            this.priceDetailFareFiledIn = priceDetailFareFiledIn;
        }

        /** 
         * Get the 'Discount' element value. Discount Information
         * 
         * @return value
         */
        public DiscountType getPriceDetailDiscount() {
            return priceDetailDiscount;
        }

        /** 
         * Set the 'Discount' element value. Discount Information
         * 
         * @param priceDetailDiscount
         */
        public void setPriceDetailDiscount(DiscountType priceDetailDiscount) {
            this.priceDetailDiscount = priceDetailDiscount;
        }

        /** 
         * Get the 'Surcharges' element value.
         * 
         * @return value
         */
        public Surcharges getSurcharges() {
            return surcharges;
        }

        /** 
         * Set the 'Surcharges' element value.
         * 
         * @param surcharges
         */
        public void setSurcharges(Surcharges surcharges) {
            this.surcharges = surcharges;
        }

        /** 
         * Get the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.

         * 
         * @return value
         */
        public TaxDetailType getPriceDetailTaxes() {
            return priceDetailTaxes;
        }

        /** 
         * Set the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.

         * 
         * @param priceDetailTaxes
         */
        public void setPriceDetailTaxes(TaxDetailType priceDetailTaxes) {
            this.priceDetailTaxes = priceDetailTaxes;
        }

        /** 
         * Get the 'TaxExemption' element value.
         * 
         * @return value
         */
        public TaxExemptionType getPriceDetailTaxExemption() {
            return priceDetailTaxExemption;
        }

        /** 
         * Set the 'TaxExemption' element value.
         * 
         * @param priceDetailTaxExemption
         */
        public void setPriceDetailTaxExemption(
                TaxExemptionType priceDetailTaxExemption) {
            this.priceDetailTaxExemption = priceDetailTaxExemption;
        }

        private void setPriceDetailChoiceSelect(int choice) {
            if (priceDetailChoiceSelect == -1) {
                priceDetailChoiceSelect = choice;
            } else if (priceDetailChoiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearPriceDetailChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearPriceDetailChoiceSelect() {
            priceDetailChoiceSelect = -1;
        }

        /** 
         * Check if PriceDetailAwardPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPriceDetailAwardPricing() {
            return priceDetailChoiceSelect == PRICE_DETAIL_AWARD_PRICING_CHOICE;
        }

        /** 
         * Get the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
         * 
         * @return value
         */
        public AwardPriceUnitType getPriceDetailAwardPricing() {
            return priceDetailAwardPricing;
        }

        /** 
         * Set the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
         * 
         * @param priceDetailAwardPricing
         */
        public void setPriceDetailAwardPricing(
                AwardPriceUnitType priceDetailAwardPricing) {
            setPriceDetailChoiceSelect(PRICE_DETAIL_AWARD_PRICING_CHOICE);
            this.priceDetailAwardPricing = priceDetailAwardPricing;
        }

        /** 
         * Check if PriceDetailCombinationPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPriceDetailCombinationPricing() {
            return priceDetailChoiceSelect == PRICE_DETAIL_COMBINATION_PRICING_CHOICE;
        }

        /** 
         * Get the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
         * 
         * @return value
         */
        public CombinationPriceType getPriceDetailCombinationPricing() {
            return priceDetailCombinationPricing;
        }

        /** 
         * Set the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
         * 
         * @param priceDetailCombinationPricing
         */
        public void setPriceDetailCombinationPricing(
                CombinationPriceType priceDetailCombinationPricing) {
            setPriceDetailChoiceSelect(PRICE_DETAIL_COMBINATION_PRICING_CHOICE);
            this.priceDetailCombinationPricing = priceDetailCombinationPricing;
        }

        /** 
         * Get the 'Fees' element value. Individual fee/ surcharge information would appear on the accountable document.
         * 
         * @return value
         */
        public FeeSurchargeType getPriceDetailFees() {
            return priceDetailFees;
        }

        /** 
         * Set the 'Fees' element value. Individual fee/ surcharge information would appear on the accountable document.
         * 
         * @param priceDetailFees
         */
        public void setPriceDetailFees(FeeSurchargeType priceDetailFees) {
            this.priceDetailFees = priceDetailFees;
        }

        /** 
         * Get the list of 'Service' element items.
         * 
         * @return list
         */
        public List<Service> getServiceList() {
            return serviceList;
        }

        /** 
         * Set the list of 'Service' element items.
         * 
         * @param list
         */
        public void setServiceList(List<Service> list) {
            serviceList = list;
        }

        /** 
         * Get the 'TimeLimits' element value. Order item-associated Time Limit(s).
         * 
         * @return value
         */
        public OrderItemTimeLimitsType getTimeLimits() {
            return timeLimits;
        }

        /** 
         * Set the 'TimeLimits' element value. Order item-associated Time Limit(s).
         * 
         * @param timeLimits
         */
        public void setTimeLimits(OrderItemTimeLimitsType timeLimits) {
            this.timeLimits = timeLimits;
        }

        /** 
         * Get the 'InventoryGuarantee' element value.
         * 
         * @return value
         */
        public InventoryGuarantee getInventoryGuarantee() {
            return inventoryGuarantee;
        }

        /** 
         * Set the 'InventoryGuarantee' element value.
         * 
         * @param inventoryGuarantee
         */
        public void setInventoryGuarantee(InventoryGuarantee inventoryGuarantee) {
            this.inventoryGuarantee = inventoryGuarantee;
        }

        /** 
         * Get the 'Disclosures' element value.
         * 
         * @return value
         */
        public DisclosureType getDisclosures() {
            return disclosures;
        }

        /** 
         * Set the 'Disclosures' element value.
         * 
         * @param disclosures
         */
        public void setDisclosures(DisclosureType disclosures) {
            this.disclosures = disclosures;
        }

        /** 
         * Get the 'Penalty' element value. Penalty information.
         * 
         * @return value
         */
        public PenaltyType getPenalty() {
            return penalty;
        }

        /** 
         * Set the 'Penalty' element value. Penalty information.
         * 
         * @param penalty
         */
        public void setPenalty(PenaltyType penalty) {
            this.penalty = penalty;
        }

        /** 
         * Get the 'OrderItemDetails' element value.
         * 
         * @return value
         */
        public OrderItemDetails getOrderItemDetails() {
            return orderItemDetails;
        }

        /** 
         * Set the 'OrderItemDetails' element value.
         * 
         * @param orderItemDetails
         */
        public void setOrderItemDetails(OrderItemDetails orderItemDetails) {
            this.orderItemDetails = orderItemDetails;
        }

        /** 
         * Get the list of 'FareDetail' element items. Fare Detail, including Fare Component and Fare Rules.
         * 
         * @return list
         */
        public List<FareDetailType> getFareDetailList() {
            return fareDetailList;
        }

        /** 
         * Set the list of 'FareDetail' element items. Fare Detail, including Fare Component and Fare Rules.
         * 
         * @param list
         */
        public void setFareDetailList(List<FareDetailType> list) {
            fareDetailList = list;
        }

        /** 
         * Get the 'OrderItemID' attribute value. The airline-assigned unique Order Item ID. Example: ORD769-A850-4EC4-8F46-02293F72D7E6
         * 
         * @return value
         */
        public String getOrderItemID() {
            return orderItemID;
        }

        /** 
         * Set the 'OrderItemID' attribute value. The airline-assigned unique Order Item ID. Example: ORD769-A850-4EC4-8F46-02293F72D7E6
         * 
         * @param orderItemID
         */
        public void setOrderItemID(String orderItemID) {
            this.orderItemID = orderItemID;
        }

        /** 
         * Get the 'Owner' attribute value. Airline designator or CRS code of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

        Encoding Scheme: IATA/ A4A (two or three character) Airline or CRS Designator Code
         * 
         * @return value
         */
        public String getOwner() {
            return owner;
        }

        /** 
         * Set the 'Owner' attribute value. Airline designator or CRS code of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

        Encoding Scheme: IATA/ A4A (two or three character) Airline or CRS Designator Code
         * 
         * @param owner
         */
        public void setOwner(String owner) {
            this.owner = owner;
        }

        /** 
         * Get the 'OwnerType' attribute value. The POA OrderID should only go to the ORA, not back to the seller.
        1. ORA
        2. POA
         * 
         * @return value
         */
        public String getOwnerType() {
            return ownerType;
        }

        /** 
         * Set the 'OwnerType' attribute value. The POA OrderID should only go to the ORA, not back to the seller.
        1. ORA
        2. POA
         * 
         * @param ownerType
         */
        public void setOwnerType(String ownerType) {
            this.ownerType = ownerType;
        }

        /** 
         * Get the 'Timestamp' attribute value. Timestamp. Example: 2017-01-13T13:59:38Z
         * 
         * @return value
         */
        public DateTime getTimestamp() {
            return timestamp;
        }

        /** 
         * Set the 'Timestamp' attribute value. Timestamp. Example: 2017-01-13T13:59:38Z
         * 
         * @param timestamp
         */
        public void setTimestamp(DateTime timestamp) {
            this.timestamp = timestamp;
        }

        /** 
         * Get the 'WebAddressID' attribute value. Deep linking into another site to complete the transaction.
         * 
         * @return value
         */
        public String getWebAddressID() {
            return webAddressID;
        }

        /** 
         * Set the 'WebAddressID' attribute value. Deep linking into another site to complete the transaction.
         * 
         * @param webAddressID
         */
        public void setWebAddressID(String webAddressID) {
            this.webAddressID = webAddressID;
        }
        /** 
         * Total price amount.

        Notes:
        1. This is typically the lowest price for this alternate lead shopping date.
        2. If expressed in currency, this price should include base price, taxes and fees/ surcharges.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalAmount" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:choice>
         *       &lt;xs:element ref="AwardPricing"/>
         *       &lt;xs:element ref="CombinationPricing"/>
         *       &lt;xs:element ref="DetailCurrencyPrice"/>
         *       &lt;xs:element ref="EncodedCurrencyPrice"/>
         *       &lt;xs:element ref="SimpleCurrencyPrice"/>
         *     &lt;/xs:choice>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TotalAmount implements Serializable
        {
            private int totalAmountSelect = -1;
            private static final int AWARD_PRICING_CHOICE = 0;
            private static final int COMBINATION_PRICING_CHOICE = 1;
            private static final int DETAIL_CURRENCY_PRICE_CHOICE = 2;
            private static final int ENCODED_CURRENCY_PRICE_CHOICE = 3;
            private static final int SIMPLE_CURRENCY_PRICE_CHOICE = 4;
            private AwardPriceUnitType awardPricing;
            private CombinationPriceType combinationPricing;
            private DetailCurrencyPriceType detailCurrencyPrice;
            private EncodedCurrencyPrice encodedCurrencyPrice;
            private SimpleCurrencyPrice simpleCurrencyPrice;

            private void setTotalAmountSelect(int choice) {
                if (totalAmountSelect == -1) {
                    totalAmountSelect = choice;
                } else if (totalAmountSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearTotalAmountSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearTotalAmountSelect() {
                totalAmountSelect = -1;
            }

            /** 
             * Check if AwardPricing is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifAwardPricing() {
                return totalAmountSelect == AWARD_PRICING_CHOICE;
            }

            /** 
             * Get the 'AwardPricing' element value.
             * 
             * @return value
             */
            public AwardPriceUnitType getAwardPricing() {
                return awardPricing;
            }

            /** 
             * Set the 'AwardPricing' element value.
             * 
             * @param awardPricing
             */
            public void setAwardPricing(AwardPriceUnitType awardPricing) {
                setTotalAmountSelect(AWARD_PRICING_CHOICE);
                this.awardPricing = awardPricing;
            }

            /** 
             * Check if CombinationPricing is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifCombinationPricing() {
                return totalAmountSelect == COMBINATION_PRICING_CHOICE;
            }

            /** 
             * Get the 'CombinationPricing' element value.
             * 
             * @return value
             */
            public CombinationPriceType getCombinationPricing() {
                return combinationPricing;
            }

            /** 
             * Set the 'CombinationPricing' element value.
             * 
             * @param combinationPricing
             */
            public void setCombinationPricing(
                    CombinationPriceType combinationPricing) {
                setTotalAmountSelect(COMBINATION_PRICING_CHOICE);
                this.combinationPricing = combinationPricing;
            }

            /** 
             * Check if DetailCurrencyPrice is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifDetailCurrencyPrice() {
                return totalAmountSelect == DETAIL_CURRENCY_PRICE_CHOICE;
            }

            /** 
             * Get the 'DetailCurrencyPrice' element value.
             * 
             * @return value
             */
            public DetailCurrencyPriceType getDetailCurrencyPrice() {
                return detailCurrencyPrice;
            }

            /** 
             * Set the 'DetailCurrencyPrice' element value.
             * 
             * @param detailCurrencyPrice
             */
            public void setDetailCurrencyPrice(
                    DetailCurrencyPriceType detailCurrencyPrice) {
                setTotalAmountSelect(DETAIL_CURRENCY_PRICE_CHOICE);
                this.detailCurrencyPrice = detailCurrencyPrice;
            }

            /** 
             * Check if EncodedCurrencyPrice is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifEncodedCurrencyPrice() {
                return totalAmountSelect == ENCODED_CURRENCY_PRICE_CHOICE;
            }

            /** 
             * Get the 'EncodedCurrencyPrice' element value.
             * 
             * @return value
             */
            public EncodedCurrencyPrice getEncodedCurrencyPrice() {
                return encodedCurrencyPrice;
            }

            /** 
             * Set the 'EncodedCurrencyPrice' element value.
             * 
             * @param encodedCurrencyPrice
             */
            public void setEncodedCurrencyPrice(
                    EncodedCurrencyPrice encodedCurrencyPrice) {
                setTotalAmountSelect(ENCODED_CURRENCY_PRICE_CHOICE);
                this.encodedCurrencyPrice = encodedCurrencyPrice;
            }

            /** 
             * Check if SimpleCurrencyPrice is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifSimpleCurrencyPrice() {
                return totalAmountSelect == SIMPLE_CURRENCY_PRICE_CHOICE;
            }

            /** 
             * Get the 'SimpleCurrencyPrice' element value.
             * 
             * @return value
             */
            public SimpleCurrencyPrice getSimpleCurrencyPrice() {
                return simpleCurrencyPrice;
            }

            /** 
             * Set the 'SimpleCurrencyPrice' element value.
             * 
             * @param simpleCurrencyPrice
             */
            public void setSimpleCurrencyPrice(
                    SimpleCurrencyPrice simpleCurrencyPrice) {
                setTotalAmountSelect(SIMPLE_CURRENCY_PRICE_CHOICE);
                this.simpleCurrencyPrice = simpleCurrencyPrice;
            }
        }
        /** 
         * Applicable Surcharge(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surcharges" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="FeeSurchargeType" name="Surcharge" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Surcharges implements Serializable
        {
            private List<FeeSurchargeType> surchargeList = new ArrayList<FeeSurchargeType>();

            /** 
             * Get the list of 'Surcharge' element items. Surcharge detail.
             * 
             * @return list
             */
            public List<FeeSurchargeType> getSurchargeList() {
                return surchargeList;
            }

            /** 
             * Set the list of 'Surcharge' element items. Surcharge detail.
             * 
             * @param list
             */
            public void setSurchargeList(List<FeeSurchargeType> list) {
                surchargeList = list;
            }
        }
        /** 
         * The individual instance of a specific Service (as described in DataLists' ServiceDefinitions) or service bundle as it has been offered, and eventually ordered by a specific Passenger.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Service" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="PassengerRef"/>
         *       &lt;xs:element type="xs:string" name="ServiceRef" minOccurs="0"/>
         *       &lt;xs:choice>
         *         &lt;xs:element type="xs:string" name="SegmentRef"/>
         *         &lt;xs:element name="ServiceDefinitionRef">
         *           &lt;xs:complexType>
         *             &lt;xs:simpleContent>
         *               &lt;xs:extension base="xs:string">
         *                 &lt;xs:attribute type="xs:string" name="SegmentRef"/>
         *               &lt;/xs:extension>
         *             &lt;/xs:simpleContent>
         *           &lt;/xs:complexType>
         *         &lt;/xs:element>
         *         &lt;xs:element name="SelectedSeat">
         *           &lt;xs:complexType>
         *             &lt;xs:sequence>
         *               &lt;xs:element name="Seat">
         *                 &lt;xs:complexType>
         *                   &lt;xs:sequence>
         *                     &lt;xs:element type="xs:integer" name="Row"/>
         *                     &lt;xs:element type="xs:string" name="Column"/>
         *                   &lt;/xs:sequence>
         *                 &lt;/xs:complexType>
         *               &lt;/xs:element>
         *               &lt;xs:element name="SegmentRef"/>
         *               &lt;xs:element name="ServiceDefinitionRef"/>
         *             &lt;/xs:sequence>
         *           &lt;/xs:complexType>
         *         &lt;/xs:element>
         *       &lt;/xs:choice>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="required" name="ServiceID"/>
         *     &lt;xs:attribute type="xs:anySimpleType" name="ServiceStatus"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Service implements Serializable
        {
            private String passengerRef;
            private String serviceRef;
            private int choiceSelect = -1;
            private static final int SEGMENT_REF_CHOICE = 0;
            private static final int SERVICE_DEFINITION_REF_CHOICE = 1;
            private static final int SELECTED_SEAT_CHOICE = 2;
            private String segmentRef;
            private String serviceDefinitionRefString;
            private String serviceDefinitionRefSegmentRef;
            private BigInteger selectedSeatRow;
            private String selectedSeatColumn;
            private String serviceID;
            private String serviceStatus;

            /** 
             * Get the 'PassengerRef' element value.
             * 
             * @return value
             */
            public String getPassengerRef() {
                return passengerRef;
            }

            /** 
             * Set the 'PassengerRef' element value.
             * 
             * @param passengerRef
             */
            public void setPassengerRef(String passengerRef) {
                this.passengerRef = passengerRef;
            }

            /** 
             * Get the 'ServiceRef' element value. Create dependencies with parent services to which this particular ServiceItem is linked to (eg. a meal to a flight). Can reference ServiceItems across different OfferItems within the same Offer.
             * 
             * @return value
             */
            public String getServiceRef() {
                return serviceRef;
            }

            /** 
             * Set the 'ServiceRef' element value. Create dependencies with parent services to which this particular ServiceItem is linked to (eg. a meal to a flight). Can reference ServiceItems across different OfferItems within the same Offer.
             * 
             * @param serviceRef
             */
            public void setServiceRef(String serviceRef) {
                this.serviceRef = serviceRef;
            }

            private void setChoiceSelect(int choice) {
                if (choiceSelect == -1) {
                    choiceSelect = choice;
                } else if (choiceSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearChoiceSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearChoiceSelect() {
                choiceSelect = -1;
            }

            /** 
             * Check if SegmentRef is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifSegmentRef() {
                return choiceSelect == SEGMENT_REF_CHOICE;
            }

            /** 
             * Get the 'SegmentRef' element value. Reference a segment being sold as part of this OrderItem/Service.
             * 
             * @return value
             */
            public String getSegmentRef() {
                return segmentRef;
            }

            /** 
             * Set the 'SegmentRef' element value. Reference a segment being sold as part of this OrderItem/Service.
             * 
             * @param segmentRef
             */
            public void setSegmentRef(String segmentRef) {
                setChoiceSelect(SEGMENT_REF_CHOICE);
                this.segmentRef = segmentRef;
            }

            /** 
             * Check if ServiceDefinitionRef is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifServiceDefinitionRef() {
                return choiceSelect == SERVICE_DEFINITION_REF_CHOICE;
            }

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getServiceDefinitionRefString() {
                return serviceDefinitionRefString;
            }

            /** 
             * Set the extension value.
             * 
             * @param serviceDefinitionRefString
             */
            public void setServiceDefinitionRefString(
                    String serviceDefinitionRefString) {
                setChoiceSelect(SERVICE_DEFINITION_REF_CHOICE);
                this.serviceDefinitionRefString = serviceDefinitionRefString;
            }

            /** 
             * Get the 'SegmentRef' attribute value. Reference to a segment in the Datalists to restrict the eligibility of the associated ServiceDefinition.
             * 
             * @return value
             */
            public String getServiceDefinitionRefSegmentRef() {
                return serviceDefinitionRefSegmentRef;
            }

            /** 
             * Set the 'SegmentRef' attribute value. Reference to a segment in the Datalists to restrict the eligibility of the associated ServiceDefinition.
             * 
             * @param serviceDefinitionRefSegmentRef
             */
            public void setServiceDefinitionRefSegmentRef(
                    String serviceDefinitionRefSegmentRef) {
                setChoiceSelect(SERVICE_DEFINITION_REF_CHOICE);
                this.serviceDefinitionRefSegmentRef = serviceDefinitionRefSegmentRef;
            }

            /** 
             * Check if SelectedSeat is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifSelectedSeat() {
                return choiceSelect == SELECTED_SEAT_CHOICE;
            }

            /** 
             * Get the 'Row' element value. Seat row number. Example: 2
             * 
             * @return value
             */
            public BigInteger getSelectedSeatRow() {
                return selectedSeatRow;
            }

            /** 
             * Set the 'Row' element value. Seat row number. Example: 2
             * 
             * @param selectedSeatRow
             */
            public void setSelectedSeatRow(BigInteger selectedSeatRow) {
                setChoiceSelect(SELECTED_SEAT_CHOICE);
                this.selectedSeatRow = selectedSeatRow;
            }

            /** 
             * Get the 'Column' element value. Seat column to identify a particular seat position on an aircraft
             * 
             * @return value
             */
            public String getSelectedSeatColumn() {
                return selectedSeatColumn;
            }

            /** 
             * Set the 'Column' element value. Seat column to identify a particular seat position on an aircraft
             * 
             * @param selectedSeatColumn
             */
            public void setSelectedSeatColumn(String selectedSeatColumn) {
                setChoiceSelect(SELECTED_SEAT_CHOICE);
                this.selectedSeatColumn = selectedSeatColumn;
            }

            /** 
             * Get the 'ServiceID' attribute value. ID for the Service contained this OrderItem. While the OrderItem would be a direct transference of the originating OfferItem, the Services within are broken down to a more granular level (i.e. a single deliverable unit of a specific service per passenger per flight segment). Therefore, the ServiceIDs in an Order do not reflect a 1-to-1 mapping to the originating Offer’s ServiceIDs.
             * 
             * @return value
             */
            public String getServiceID() {
                return serviceID;
            }

            /** 
             * Set the 'ServiceID' attribute value. ID for the Service contained this OrderItem. While the OrderItem would be a direct transference of the originating OfferItem, the Services within are broken down to a more granular level (i.e. a single deliverable unit of a specific service per passenger per flight segment). Therefore, the ServiceIDs in an Order do not reflect a 1-to-1 mapping to the originating Offer’s ServiceIDs.
             * 
             * @param serviceID
             */
            public void setServiceID(String serviceID) {
                this.serviceID = serviceID;
            }

            /** 
             * Get the 'ServiceStatus' attribute value. Current Service status.

            Encoding Scheme: IATA Padis Codeset - List for data element 4405 (Status, coded)
             * 
             * @return value
             */
            public String getServiceStatus() {
                return serviceStatus;
            }

            /** 
             * Set the 'ServiceStatus' attribute value. Current Service status.

            Encoding Scheme: IATA Padis Codeset - List for data element 4405 (Status, coded)
             * 
             * @param serviceStatus
             */
            public void setServiceStatus(String serviceStatus) {
                this.serviceStatus = serviceStatus;
            }
        }
        /** 
         * Inventory Guarantee 
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InventoryGuarantee" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="InventoryGuaranteeID"/>
         *       &lt;xs:element ref="InventoryGuaranteeTimeLimits"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class InventoryGuarantee implements Serializable
        {
            private String inventoryGuaranteeID;
            private CoreDateGrpType inventoryGuaranteeTimeLimits;

            /** 
             * Get the 'InventoryGuaranteeID' element value. 
                                  Unique Inventory Guarantee ID. Examples: INVREF123456, 68E0-675C Note: This is a unique identifier issued by an Airline to reference that inventory for a specified offer will be guaranteed as available for a period.
                                
             * 
             * @return value
             */
            public String getInventoryGuaranteeID() {
                return inventoryGuaranteeID;
            }

            /** 
             * Set the 'InventoryGuaranteeID' element value. 
                                  Unique Inventory Guarantee ID. Examples: INVREF123456, 68E0-675C Note: This is a unique identifier issued by an Airline to reference that inventory for a specified offer will be guaranteed as available for a period.
                                
             * 
             * @param inventoryGuaranteeID
             */
            public void setInventoryGuaranteeID(String inventoryGuaranteeID) {
                this.inventoryGuaranteeID = inventoryGuaranteeID;
            }

            /** 
             * Get the 'InventoryGuaranteeTimeLimits' element value.
             * 
             * @return value
             */
            public CoreDateGrpType getInventoryGuaranteeTimeLimits() {
                return inventoryGuaranteeTimeLimits;
            }

            /** 
             * Set the 'InventoryGuaranteeTimeLimits' element value.
             * 
             * @param inventoryGuaranteeTimeLimits
             */
            public void setInventoryGuaranteeTimeLimits(
                    CoreDateGrpType inventoryGuaranteeTimeLimits) {
                this.inventoryGuaranteeTimeLimits = inventoryGuaranteeTimeLimits;
            }
        }
    }
}
