
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * OFFER ITEM IN ORDER definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderOfferItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="OfferItemID"/>
 *     &lt;xs:element name="OfferItemType">
 *       &lt;xs:complexType>
 *         &lt;xs:choice>
 *           &lt;xs:element ref="BaggageItem" maxOccurs="unbounded"/>
 *           &lt;xs:element ref="DetailedFlightItem" maxOccurs="unbounded"/>
 *           &lt;xs:element ref="OtherItem" maxOccurs="unbounded"/>
 *           &lt;xs:element ref="SeatItem" maxOccurs="unbounded"/>
 *         &lt;/xs:choice>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="OfferItemTimeLimitSetType" name="TimeLimits" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class OrderOfferItemType implements Serializable
{
    private OfferItemID offerItemID;
    private int offerItemTypeSelect = -1;
    private static final int OFFER_ITEM_TYPE_BAGGAGE_ITEM_LIST_CHOICE = 0;
    private static final int OFFER_ITEM_TYPE_DETAILED_FLIGHT_ITEM_LIST_CHOICE = 1;
    private static final int OFFER_ITEM_TYPE_OTHER_ITEM_LIST_CHOICE = 2;
    private static final int OFFER_ITEM_TYPE_SEAT_ITEM_LIST_CHOICE = 3;
    private List<BaggageItemType> offerItemTypeBaggageItemList = new ArrayList<BaggageItemType>();
    private List<FlightItemType> offerItemTypeDetailedFlightItemList = new ArrayList<FlightItemType>();
    private List<OtherItemType> offerItemTypeOtherItemList = new ArrayList<OtherItemType>();
    private List<SeatItemType> offerItemTypeSeatItemList = new ArrayList<SeatItemType>();
    private OfferItemTimeLimitSetType timeLimits;
    private String refs;

    /** 
     * Get the 'OfferItemID' element value.
     * 
     * @return value
     */
    public OfferItemID getOfferItemID() {
        return offerItemID;
    }

    /** 
     * Set the 'OfferItemID' element value.
     * 
     * @param offerItemID
     */
    public void setOfferItemID(OfferItemID offerItemID) {
        this.offerItemID = offerItemID;
    }

    private void setOfferItemTypeSelect(int choice) {
        if (offerItemTypeSelect == -1) {
            offerItemTypeSelect = choice;
        } else if (offerItemTypeSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearOfferItemTypeSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearOfferItemTypeSelect() {
        offerItemTypeSelect = -1;
    }

    /** 
     * Check if OfferItemTypeBaggageItemList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOfferItemTypeBaggageItemList() {
        return offerItemTypeSelect == OFFER_ITEM_TYPE_BAGGAGE_ITEM_LIST_CHOICE;
    }

    /** 
     * Get the list of 'BaggageItem' element items.
     * 
     * @return list
     */
    public List<BaggageItemType> getOfferItemTypeBaggageItemList() {
        return offerItemTypeBaggageItemList;
    }

    /** 
     * Set the list of 'BaggageItem' element items.
     * 
     * @param list
     */
    public void setOfferItemTypeBaggageItemList(List<BaggageItemType> list) {
        setOfferItemTypeSelect(OFFER_ITEM_TYPE_BAGGAGE_ITEM_LIST_CHOICE);
        offerItemTypeBaggageItemList = list;
    }

    /** 
     * Check if OfferItemTypeDetailedFlightItemList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOfferItemTypeDetailedFlightItemList() {
        return offerItemTypeSelect == OFFER_ITEM_TYPE_DETAILED_FLIGHT_ITEM_LIST_CHOICE;
    }

    /** 
     * Get the list of 'DetailedFlightItem' element items. Flight Offer Item.
     * 
     * @return list
     */
    public List<FlightItemType> getOfferItemTypeDetailedFlightItemList() {
        return offerItemTypeDetailedFlightItemList;
    }

    /** 
     * Set the list of 'DetailedFlightItem' element items. Flight Offer Item.
     * 
     * @param list
     */
    public void setOfferItemTypeDetailedFlightItemList(List<FlightItemType> list) {
        setOfferItemTypeSelect(OFFER_ITEM_TYPE_DETAILED_FLIGHT_ITEM_LIST_CHOICE);
        offerItemTypeDetailedFlightItemList = list;
    }

    /** 
     * Check if OfferItemTypeOtherItemList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOfferItemTypeOtherItemList() {
        return offerItemTypeSelect == OFFER_ITEM_TYPE_OTHER_ITEM_LIST_CHOICE;
    }

    /** 
     * Get the list of 'OtherItem' element items.
     * 
     * @return list
     */
    public List<OtherItemType> getOfferItemTypeOtherItemList() {
        return offerItemTypeOtherItemList;
    }

    /** 
     * Set the list of 'OtherItem' element items.
     * 
     * @param list
     */
    public void setOfferItemTypeOtherItemList(List<OtherItemType> list) {
        setOfferItemTypeSelect(OFFER_ITEM_TYPE_OTHER_ITEM_LIST_CHOICE);
        offerItemTypeOtherItemList = list;
    }

    /** 
     * Check if OfferItemTypeSeatItemList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOfferItemTypeSeatItemList() {
        return offerItemTypeSelect == OFFER_ITEM_TYPE_SEAT_ITEM_LIST_CHOICE;
    }

    /** 
     * Get the list of 'SeatItem' element items.
     * 
     * @return list
     */
    public List<SeatItemType> getOfferItemTypeSeatItemList() {
        return offerItemTypeSeatItemList;
    }

    /** 
     * Set the list of 'SeatItem' element items.
     * 
     * @param list
     */
    public void setOfferItemTypeSeatItemList(List<SeatItemType> list) {
        setOfferItemTypeSelect(OFFER_ITEM_TYPE_SEAT_ITEM_LIST_CHOICE);
        offerItemTypeSeatItemList = list;
    }

    /** 
     * Get the 'TimeLimits' element value. 
                  Time Limits, including mandatory Offer Expiration and Payment Time Limits.
                
     * 
     * @return value
     */
    public OfferItemTimeLimitSetType getTimeLimits() {
        return timeLimits;
    }

    /** 
     * Set the 'TimeLimits' element value. 
                  Time Limits, including mandatory Offer Expiration and Payment Time Limits.
                
     * 
     * @param timeLimits
     */
    public void setTimeLimits(OfferItemTimeLimitSetType timeLimits) {
        this.timeLimits = timeLimits;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
