
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * ORDER INPUT SHOPPING RESPONSE object definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderRequestType">
 *   &lt;xs:choice>
 *     &lt;xs:element name="Offer" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Offer -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="OrderOfferItemType" name="OrderItem" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrderRequestType implements Serializable
{
    private int choiceSelect = -1;
    private static final int OFFER_LIST_CHOICE = 0;
    private static final int ORDER_ITEM_LIST_CHOICE = 1;
    private List<Offer> offerList = new ArrayList<Offer>();
    private List<OrderOfferItemType> orderItemList = new ArrayList<OrderOfferItemType>();

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if OfferList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOfferList() {
        return choiceSelect == OFFER_LIST_CHOICE;
    }

    /** 
     * Get the list of 'Offer' element items.
     * 
     * @return list
     */
    public List<Offer> getOfferList() {
        return offerList;
    }

    /** 
     * Set the list of 'Offer' element items.
     * 
     * @param list
     */
    public void setOfferList(List<Offer> list) {
        setChoiceSelect(OFFER_LIST_CHOICE);
        offerList = list;
    }

    /** 
     * Check if OrderItemList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOrderItemList() {
        return choiceSelect == ORDER_ITEM_LIST_CHOICE;
    }

    /** 
     * Get the list of 'OrderItem' element items. Used for selling by value (long sells) rather than selling by reference.
     * 
     * @return list
     */
    public List<OrderOfferItemType> getOrderItemList() {
        return orderItemList;
    }

    /** 
     * Set the list of 'OrderItem' element items. Used for selling by value (long sells) rather than selling by reference.
     * 
     * @param list
     */
    public void setOrderItemList(List<OrderOfferItemType> list) {
        setChoiceSelect(ORDER_ITEM_LIST_CHOICE);
        orderItemList = list;
    }
    /** 
     * Offer selected by the Passenger for requesting an Order to be created. Multiple Offers can be requested at the same time, each of which could originate from different shopping responses (each with their own ResponseIDs).
    
    Each Offer selected could reference (via the OfferID) either standard Offers from an AirShoppingRS message (potentially with Flight-related services) or A-La-Carte Offers (containing optional ancillary services). These standard Offers and “a-la-carte” Offers would need to be consistent with the applicability rules defined by their relations (passengers or segments eligible for the enclosed OfferItems) and would be combined to produce a single Order, returned by the OrderViewRS message.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Offer" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="CurrencyAmountOptType" name="TotalOfferPrice" minOccurs="0"/>
     *       &lt;xs:element name="OfferItem" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class OfferItem -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="required" name="OfferID"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="Owner"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="ResponseID"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Offer implements Serializable
    {
        private CurrencyAmountOptType totalOfferPrice;
        private List<OfferItem> offerItemList = new ArrayList<OfferItem>();
        private String offerID;
        private String owner;
        private String responseID;

        /** 
         * Get the 'TotalOfferPrice' element value. The total price for all selected Offer Items (and respective quantities) for all passengers and segments associated with the respective Offer(s), as calculated by the seller system. Without adding any optional Offer Items, the value of this TotalOfferPrice should be that of the TotalPrice of the Offer(s) being referenced.
         * 
         * @return value
         */
        public CurrencyAmountOptType getTotalOfferPrice() {
            return totalOfferPrice;
        }

        /** 
         * Set the 'TotalOfferPrice' element value. The total price for all selected Offer Items (and respective quantities) for all passengers and segments associated with the respective Offer(s), as calculated by the seller system. Without adding any optional Offer Items, the value of this TotalOfferPrice should be that of the TotalPrice of the Offer(s) being referenced.
         * 
         * @param totalOfferPrice
         */
        public void setTotalOfferPrice(CurrencyAmountOptType totalOfferPrice) {
            this.totalOfferPrice = totalOfferPrice;
        }

        /** 
         * Get the list of 'OfferItem' element items.
         * 
         * @return list
         */
        public List<OfferItem> getOfferItemList() {
            return offerItemList;
        }

        /** 
         * Set the list of 'OfferItem' element items.
         * 
         * @param list
         */
        public void setOfferItemList(List<OfferItem> list) {
            offerItemList = list;
        }

        /** 
         * Get the 'OfferID' attribute value. Reference to the OfferID of the selected Offer (either a standard Offer or an a-la-carte Offer) returned in a previous shopping response.
         * 
         * @return value
         */
        public String getOfferID() {
            return offerID;
        }

        /** 
         * Set the 'OfferID' attribute value. Reference to the OfferID of the selected Offer (either a standard Offer or an a-la-carte Offer) returned in a previous shopping response.
         * 
         * @param offerID
         */
        public void setOfferID(String offerID) {
            this.offerID = offerID;
        }

        /** 
         * Get the 'Owner' attribute value. Designator of Airline that owns/ assigned these IDs. Examples: BA

        Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
         * 
         * @return value
         */
        public String getOwner() {
            return owner;
        }

        /** 
         * Set the 'Owner' attribute value. Designator of Airline that owns/ assigned these IDs. Examples: BA

        Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
         * 
         * @param owner
         */
        public void setOwner(String owner) {
            this.owner = owner;
        }

        /** 
         * Get the 'ResponseID' attribute value. Reference to unique shopping session response ID, as provided in the airline's previous shopping response.
         * 
         * @return value
         */
        public String getResponseID() {
            return responseID;
        }

        /** 
         * Set the 'ResponseID' attribute value. Reference to unique shopping session response ID, as provided in the airline's previous shopping response.
         * 
         * @param responseID
         */
        public void setResponseID(String responseID) {
            this.responseID = responseID;
        }
        /** 
         * OfferItem selected by the Passenger for inclusion in the requested Order. Repeat occurrence of OfferItem (once per passenger) if different passengers want to select different service options, different quantities of a-la-carte items or different seat locations.
        
        As a minimum, all mandatory OfferItems from a desired Offer should be explicitly defined within these selections and should repeat the same Passenger and Flight Segment associations defined in the originating OfferItems. Optional OfferItems may then be appended as further items selected by the Passenger.
        
        OfferItems from the originating Offers may take on two different forms, which in turn drives how the ALaCarteSelection element is to be used - If the OfferItem referenced comes originally from an a-la-carte Offer, then the use of the ALaCarteSelection element should be used to defined the Quantity of said OfferItem. On the other hand, if the OfferItem comes from a standard type of Offer in the previous shopping response, the ALaCarteSelection element should not be used, as the quantity is explicitly driven by what is defined in that OfferItem’s associations (to passengers and/or flight segments).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferItem" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="PassengerRefs"/>
         *       &lt;xs:element name="ALaCarteSelection" minOccurs="0">
         *         &lt;!-- Reference to inner class ALaCarteSelection -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ServiceSelection" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class ServiceSelection -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="SeatSelection" minOccurs="0">
         *         &lt;!-- Reference to inner class SeatSelection -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="required" name="OfferItemID"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OfferItem implements Serializable
        {
            private String passengerRefs;
            private ALaCarteSelection ALaCarteSelection1;
            private List<ServiceSelection> serviceSelectionList = new ArrayList<ServiceSelection>();
            private SeatSelection seatSelection;
            private String offerItemID;

            /** 
             * Get the 'PassengerRefs' element value. Reference to passenger(s) for which this OfferItem and selected Services (in case of Service Bundles) applies.
             * 
             * @return value
             */
            public String getPassengerRefs() {
                return passengerRefs;
            }

            /** 
             * Set the 'PassengerRefs' element value. Reference to passenger(s) for which this OfferItem and selected Services (in case of Service Bundles) applies.
             * 
             * @param passengerRefs
             */
            public void setPassengerRefs(String passengerRefs) {
                this.passengerRefs = passengerRefs;
            }

            /** 
             * Get the 'ALaCarteSelection' element value.
             * 
             * @return value
             */
            public ALaCarteSelection getALaCarteSelection1() {
                return ALaCarteSelection1;
            }

            /** 
             * Set the 'ALaCarteSelection' element value.
             * 
             * @param ALaCarteSelection1
             */
            public void setALaCarteSelection1(
                    ALaCarteSelection ALaCarteSelection1) {
                this.ALaCarteSelection1 = ALaCarteSelection1;
            }

            /** 
             * Get the list of 'ServiceSelection' element items.
             * 
             * @return list
             */
            public List<ServiceSelection> getServiceSelectionList() {
                return serviceSelectionList;
            }

            /** 
             * Set the list of 'ServiceSelection' element items.
             * 
             * @param list
             */
            public void setServiceSelectionList(List<ServiceSelection> list) {
                serviceSelectionList = list;
            }

            /** 
             * Get the 'SeatSelection' element value.
             * 
             * @return value
             */
            public SeatSelection getSeatSelection() {
                return seatSelection;
            }

            /** 
             * Set the 'SeatSelection' element value.
             * 
             * @param seatSelection
             */
            public void setSeatSelection(SeatSelection seatSelection) {
                this.seatSelection = seatSelection;
            }

            /** 
             * Get the 'OfferItemID' attribute value. Reference to the OfferItemID of the selected OfferItem (contained in either a standard Offer or an a-la-carte Offer) returned in a previous shopping response.
             * 
             * @return value
             */
            public String getOfferItemID() {
                return offerItemID;
            }

            /** 
             * Set the 'OfferItemID' attribute value. Reference to the OfferItemID of the selected OfferItem (contained in either a standard Offer or an a-la-carte Offer) returned in a previous shopping response.
             * 
             * @param offerItemID
             */
            public void setOfferItemID(String offerItemID) {
                this.offerItemID = offerItemID;
            }
            /** 
             * Use to select the quantity of Offer Items from the A La Carte Offer Items.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ALaCarteSelection" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:int" name="Quantity"/>
             *       &lt;xs:element type="xs:string" name="SegmentID" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ALaCarteSelection implements Serializable
            {
                private int quantity;
                private String segmentID;

                /** 
                 * Get the 'Quantity' element value. Quantity to allow the ordering of more than one instances of the related a la carte OfferItem. 
                 * 
                 * @return value
                 */
                public int getQuantity() {
                    return quantity;
                }

                /** 
                 * Set the 'Quantity' element value. Quantity to allow the ordering of more than one instances of the related a la carte OfferItem. 
                 * 
                 * @param quantity
                 */
                public void setQuantity(int quantity) {
                    this.quantity = quantity;
                }

                /** 
                 * Get the 'SegmentID' element value. Reference to segment proposed in original Offer Item's elibigility rules.
                 * 
                 * @return value
                 */
                public String getSegmentID() {
                    return segmentID;
                }

                /** 
                 * Set the 'SegmentID' element value. Reference to segment proposed in original Offer Item's elibigility rules.
                 * 
                 * @param segmentID
                 */
                public void setSegmentID(String segmentID) {
                    this.segmentID = segmentID;
                }
            }
            /** 
             * For service bundle selection - only to be used for bundles with optional choices (e.g. pick 2 out of 4)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceSelection" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:complexContent>
             *       &lt;xs:extension base="RequestedServiceType">
             *         &lt;xs:attribute type="xs:string" use="required" name="ServiceID"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:complexContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ServiceSelection extends RequestedServiceType
                implements Serializable
            {
                private String serviceID;

                /** 
                 * Get the 'ServiceID' attribute value. Reference to the Service (within the OfferItem) from which the bundling begins
                 * 
                 * @return value
                 */
                public String getServiceID() {
                    return serviceID;
                }

                /** 
                 * Set the 'ServiceID' attribute value. Reference to the Service (within the OfferItem) from which the bundling begins
                 * 
                 * @param serviceID
                 */
                public void setServiceID(String serviceID) {
                    this.serviceID = serviceID;
                }
            }
            /** 
             * Selection of specific seat location, as provided in seat availability messages.

            When used, only a single Passenger must be referenced for a single Segment
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatSelection" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:integer" name="Row"/>
             *       &lt;xs:element type="xs:string" name="Column"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SeatSelection implements Serializable
            {
                private BigInteger row;
                private String column;

                /** 
                 * Get the 'Row' element value. Seat row number. Example: 2
                 * 
                 * @return value
                 */
                public BigInteger getRow() {
                    return row;
                }

                /** 
                 * Set the 'Row' element value. Seat row number. Example: 2
                 * 
                 * @param row
                 */
                public void setRow(BigInteger row) {
                    this.row = row;
                }

                /** 
                 * Get the 'Column' element value. Seat column to identify a particular seat position on an aircraft
                 * 
                 * @return value
                 */
                public String getColumn() {
                    return column;
                }

                /** 
                 * Set the 'Column' element value. Seat column to identify a particular seat position on an aircraft
                 * 
                 * @param column
                 */
                public void setColumn(String column) {
                    this.column = column;
                }
            }
        }
    }
}
