
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * Origin/ Destination information. Contains a list of all Flight element that are part of that OD.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestination">
 *   &lt;xs:complexType>
 *     &lt;xs:complexContent>
 *       &lt;xs:extension base="OriginDestinationType">
 *         &lt;xs:sequence>
 *           &lt;xs:element ref="TotalJourney" minOccurs="0"/>
 *           &lt;xs:element ref="FlightReferences" minOccurs="0"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:extension>
 *     &lt;/xs:complexContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OriginDestination extends OriginDestinationType implements
    Serializable
{
    private TotalJourneyType totalJourney;
    private FlightReferences flightReferences;

    /** 
     * Get the 'TotalJourney' element value.
     * 
     * @return value
     */
    public TotalJourneyType getTotalJourney() {
        return totalJourney;
    }

    /** 
     * Set the 'TotalJourney' element value.
     * 
     * @param totalJourney
     */
    public void setTotalJourney(TotalJourneyType totalJourney) {
        this.totalJourney = totalJourney;
    }

    /** 
     * Get the 'FlightReferences' element value.
     * 
     * @return value
     */
    public FlightReferences getFlightReferences() {
        return flightReferences;
    }

    /** 
     * Set the 'FlightReferences' element value.
     * 
     * @param flightReferences
     */
    public void setFlightReferences(FlightReferences flightReferences) {
        this.flightReferences = flightReferences;
    }
}
