
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * Core Other Offer definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherOfferCoreType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="OfferPrice">
 *       &lt;xs:complexType>
 *         &lt;xs:choice>
 *           &lt;xs:element type="AwardPriceUnitType" name="AwardPricing"/>
 *           &lt;xs:element type="CombinationPriceType" name="CombinationPricing"/>
 *           &lt;xs:element type="DetailCurrencyPriceType" name="DetailCurrencyPrice"/>
 *           &lt;xs:element type="CurrencyAmountEncodedType" name="EncodedCurrencyPrice"/>
 *           &lt;xs:element type="CurrencyAmountOptType" name="SimpleCurrencyPrice"/>
 *         &lt;/xs:choice>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OtherOfferCoreType implements Serializable
{
    private int offerPriceSelect = -1;
    private static final int OFFER_PRICE_AWARD_PRICING_CHOICE = 0;
    private static final int OFFER_PRICE_COMBINATION_PRICING_CHOICE = 1;
    private static final int OFFER_PRICE_DETAIL_CURRENCY_PRICE_CHOICE = 2;
    private static final int OFFER_PRICE_ENCODED_CURRENCY_PRICE_CHOICE = 3;
    private static final int OFFER_PRICE_SIMPLE_CURRENCY_PRICE_CHOICE = 4;
    private AwardPriceUnitType offerPriceAwardPricing;
    private CombinationPriceType offerPriceCombinationPricing;
    private DetailCurrencyPriceType offerPriceDetailCurrencyPrice;
    private CurrencyAmountEncodedType offerPriceEncodedCurrencyPrice;
    private CurrencyAmountOptType offerPriceSimpleCurrencyPrice;

    private void setOfferPriceSelect(int choice) {
        if (offerPriceSelect == -1) {
            offerPriceSelect = choice;
        } else if (offerPriceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearOfferPriceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearOfferPriceSelect() {
        offerPriceSelect = -1;
    }

    /** 
     * Check if OfferPriceAwardPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOfferPriceAwardPricing() {
        return offerPriceSelect == OFFER_PRICE_AWARD_PRICING_CHOICE;
    }

    /** 
     * Get the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
     * 
     * @return value
     */
    public AwardPriceUnitType getOfferPriceAwardPricing() {
        return offerPriceAwardPricing;
    }

    /** 
     * Set the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
     * 
     * @param offerPriceAwardPricing
     */
    public void setOfferPriceAwardPricing(
            AwardPriceUnitType offerPriceAwardPricing) {
        setOfferPriceSelect(OFFER_PRICE_AWARD_PRICING_CHOICE);
        this.offerPriceAwardPricing = offerPriceAwardPricing;
    }

    /** 
     * Check if OfferPriceCombinationPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOfferPriceCombinationPricing() {
        return offerPriceSelect == OFFER_PRICE_COMBINATION_PRICING_CHOICE;
    }

    /** 
     * Get the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
     * 
     * @return value
     */
    public CombinationPriceType getOfferPriceCombinationPricing() {
        return offerPriceCombinationPricing;
    }

    /** 
     * Set the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
     * 
     * @param offerPriceCombinationPricing
     */
    public void setOfferPriceCombinationPricing(
            CombinationPriceType offerPriceCombinationPricing) {
        setOfferPriceSelect(OFFER_PRICE_COMBINATION_PRICING_CHOICE);
        this.offerPriceCombinationPricing = offerPriceCombinationPricing;
    }

    /** 
     * Check if OfferPriceDetailCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOfferPriceDetailCurrencyPrice() {
        return offerPriceSelect == OFFER_PRICE_DETAIL_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'DetailCurrencyPrice' element value. A (detailed) CURRENCY-based Price with Price Break-down for Tax and/ or Fee information.
     * 
     * @return value
     */
    public DetailCurrencyPriceType getOfferPriceDetailCurrencyPrice() {
        return offerPriceDetailCurrencyPrice;
    }

    /** 
     * Set the 'DetailCurrencyPrice' element value. A (detailed) CURRENCY-based Price with Price Break-down for Tax and/ or Fee information.
     * 
     * @param offerPriceDetailCurrencyPrice
     */
    public void setOfferPriceDetailCurrencyPrice(
            DetailCurrencyPriceType offerPriceDetailCurrencyPrice) {
        setOfferPriceSelect(OFFER_PRICE_DETAIL_CURRENCY_PRICE_CHOICE);
        this.offerPriceDetailCurrencyPrice = offerPriceDetailCurrencyPrice;
    }

    /** 
     * Check if OfferPriceEncodedCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOfferPriceEncodedCurrencyPrice() {
        return offerPriceSelect == OFFER_PRICE_ENCODED_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'EncodedCurrencyPrice' element value. Monetary value amount and currency code.
     * 
     * @return value
     */
    public CurrencyAmountEncodedType getOfferPriceEncodedCurrencyPrice() {
        return offerPriceEncodedCurrencyPrice;
    }

    /** 
     * Set the 'EncodedCurrencyPrice' element value. Monetary value amount and currency code.
     * 
     * @param offerPriceEncodedCurrencyPrice
     */
    public void setOfferPriceEncodedCurrencyPrice(
            CurrencyAmountEncodedType offerPriceEncodedCurrencyPrice) {
        setOfferPriceSelect(OFFER_PRICE_ENCODED_CURRENCY_PRICE_CHOICE);
        this.offerPriceEncodedCurrencyPrice = offerPriceEncodedCurrencyPrice;
    }

    /** 
     * Check if OfferPriceSimpleCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOfferPriceSimpleCurrencyPrice() {
        return offerPriceSelect == OFFER_PRICE_SIMPLE_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'SimpleCurrencyPrice' element value. A (simple) CURRENCY-based Price with NO taxes and/ or fees.
    Examples: 100.00, 100, 100 (USD)
     * 
     * @return value
     */
    public CurrencyAmountOptType getOfferPriceSimpleCurrencyPrice() {
        return offerPriceSimpleCurrencyPrice;
    }

    /** 
     * Set the 'SimpleCurrencyPrice' element value. A (simple) CURRENCY-based Price with NO taxes and/ or fees.
    Examples: 100.00, 100, 100 (USD)
     * 
     * @param offerPriceSimpleCurrencyPrice
     */
    public void setOfferPriceSimpleCurrencyPrice(
            CurrencyAmountOptType offerPriceSimpleCurrencyPrice) {
        setOfferPriceSelect(OFFER_PRICE_SIMPLE_CURRENCY_PRICE_CHOICE);
        this.offerPriceSimpleCurrencyPrice = offerPriceSimpleCurrencyPrice;
    }
}
