
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * Passenger Authentication definition.

 Notes:
 1. The AuthQuestion is returned as an Alert in a Shopping or Order response message.
 2. The AuthAnswer is returned as an Alert in a Shopping or Order request message.
 3. Note that the CustomerInputRQ may be used to send an authentication response in lieue of using an alert in a request message.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PIN_AuthTravelerType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="TrxProcessObjectBaseType">
 *       &lt;xs:choice>
 *         &lt;xs:element name="AuthRequest">
 *           &lt;xs:complexType>
 *             &lt;xs:complexContent>
 *               &lt;xs:extension base="PinPhraseQuestionType">
 *                 &lt;xs:attribute type="xs:boolean" use="optional" name="AuthenticationInd"/>
 *                 &lt;xs:attribute type="xs:boolean" use="optional" name="MaximumTrxInd"/>
 *                 &lt;xs:attribute type="xs:boolean" use="optional" name="RetryInd"/>
 *               &lt;/xs:extension>
 *             &lt;/xs:complexContent>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element type="PinPhraseAnswerType" name="AuthResponse"/>
 *       &lt;/xs:choice>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PINAuthTravelerType extends TrxProcessObjectBaseType implements
    Serializable
{
    private int choiceSelect = -1;
    private static final int AUTH_REQUEST_CHOICE = 0;
    private static final int AUTH_RESPONSE_CHOICE = 1;
    private PinPhraseQuestionType authRequestPinPhraseQuestionType;
    private Boolean authRequestAuthenticationInd;
    private Boolean authRequestMaximumTrxInd;
    private Boolean authRequestRetryInd;
    private PinPhraseAnswerType authResponse;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if AuthRequest is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAuthRequest() {
        return choiceSelect == AUTH_REQUEST_CHOICE;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public PinPhraseQuestionType getAuthRequestPinPhraseQuestionType() {
        return authRequestPinPhraseQuestionType;
    }

    /** 
     * Set the extension value.
     * 
     * @param authRequestPinPhraseQuestionType
     */
    public void setAuthRequestPinPhraseQuestionType(
            PinPhraseQuestionType authRequestPinPhraseQuestionType) {
        setChoiceSelect(AUTH_REQUEST_CHOICE);
        this.authRequestPinPhraseQuestionType = authRequestPinPhraseQuestionType;
    }

    /** 
     * Get the 'AuthenticationInd' attribute value. When true, fulfullment of this Order requires additional Traveler authentication.
     * 
     * @return value
     */
    public Boolean getAuthRequestAuthenticationInd() {
        return authRequestAuthenticationInd;
    }

    /** 
     * Set the 'AuthenticationInd' attribute value. When true, fulfullment of this Order requires additional Traveler authentication.
     * 
     * @param authRequestAuthenticationInd
     */
    public void setAuthRequestAuthenticationInd(
            Boolean authRequestAuthenticationInd) {
        setChoiceSelect(AUTH_REQUEST_CHOICE);
        this.authRequestAuthenticationInd = authRequestAuthenticationInd;
    }

    /** 
     * Get the 'MaximumTrxInd' attribute value. When true, the maximum Authentication attempts have been exceeded.
     * 
     * @return value
     */
    public Boolean getAuthRequestMaximumTrxInd() {
        return authRequestMaximumTrxInd;
    }

    /** 
     * Set the 'MaximumTrxInd' attribute value. When true, the maximum Authentication attempts have been exceeded.
     * 
     * @param authRequestMaximumTrxInd
     */
    public void setAuthRequestMaximumTrxInd(Boolean authRequestMaximumTrxInd) {
        setChoiceSelect(AUTH_REQUEST_CHOICE);
        this.authRequestMaximumTrxInd = authRequestMaximumTrxInd;
    }

    /** 
     * Get the 'RetryInd' attribute value. When true, the Authentication transaction should be resent.
     * 
     * @return value
     */
    public Boolean getAuthRequestRetryInd() {
        return authRequestRetryInd;
    }

    /** 
     * Set the 'RetryInd' attribute value. When true, the Authentication transaction should be resent.
     * 
     * @param authRequestRetryInd
     */
    public void setAuthRequestRetryInd(Boolean authRequestRetryInd) {
        setChoiceSelect(AUTH_REQUEST_CHOICE);
        this.authRequestRetryInd = authRequestRetryInd;
    }

    /** 
     * Check if AuthResponse is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAuthResponse() {
        return choiceSelect == AUTH_RESPONSE_CHOICE;
    }

    /** 
     * Get the 'AuthResponse' element value. PIN Phrase Authentication Response.
     * 
     * @return value
     */
    public PinPhraseAnswerType getAuthResponse() {
        return authResponse;
    }

    /** 
     * Set the 'AuthResponse' element value. PIN Phrase Authentication Response.
     * 
     * @param authResponse
     */
    public void setAuthResponse(PinPhraseAnswerType authResponse) {
        setChoiceSelect(AUTH_RESPONSE_CHOICE);
        this.authResponse = authResponse;
    }
}
