
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for Requested and Priced Passenger Type Code(s) and Quantity.

 Passenger type code and Traveler quantity.  Example: ADT

 Encoding scheme:  IATA (three character) Passenger Type Code
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PTC_QuantityPricedType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="PTC_QuantityType" name="Requested" minOccurs="0"/>
 *     &lt;xs:element type="PTC_QuantityType" name="Priced" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class PTCQuantityPricedType implements Serializable
{
    private PTCQuantityType requested;
    private PTCQuantityType priced;
    private String refs;

    /** 
     * Get the 'Requested' element value. Requested passenger type code for pricing. Example: CHD

    Encoding scheme: IATA (three character) Passenger Type Code
     * 
     * @return value
     */
    public PTCQuantityType getRequested() {
        return requested;
    }

    /** 
     * Set the 'Requested' element value. Requested passenger type code for pricing. Example: CHD

    Encoding scheme: IATA (three character) Passenger Type Code
     * 
     * @param requested
     */
    public void setRequested(PTCQuantityType requested) {
        this.requested = requested;
    }

    /** 
     * Get the 'Priced' element value. Actual passenger type code used for for pricing.  Example: ADT

    Encoding scheme: IATA (three character) Passenger Type Code
     * 
     * @return value
     */
    public PTCQuantityType getPriced() {
        return priced;
    }

    /** 
     * Set the 'Priced' element value. Actual passenger type code used for for pricing.  Example: ADT

    Encoding scheme: IATA (three character) Passenger Type Code
     * 
     * @param priced
     */
    public void setPriced(PTCQuantityType priced) {
        this.priced = priced;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
