
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.LocalDate;

/** 
 * Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.  Holds the attributes specific to a one booking, from shopping to fulfilment.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="PTC" minOccurs="0"/>
 *     &lt;xs:choice minOccurs="0">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *     &lt;xs:element type="xs:string" name="ResidenceCountryCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CitizenshipCountryCode" minOccurs="0"/>
 *     &lt;xs:element type="IndividualType" name="Individual" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ProfileID" minOccurs="0"/>
 *     &lt;xs:element type="LoyaltyProgramAccountType" name="LoyaltyProgramAccount" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="FOID" name="FOID" minOccurs="0"/>
 *     &lt;xs:element type="IdentityDocumentType" name="IdentityDocument" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="ContactInfoRef" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="InfantRef" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="LanguageUsageType" name="Language" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="RemarkTypeAIDM" name="Remark" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="PassengerID"/>
 *   &lt;xs:attribute type="xs:boolean" name="ProfileConsentIndicator"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PassengerType implements Serializable
{
    private String PTC;
    private Choice choice;
    private String residenceCountryCode;
    private String citizenshipCountryCode;
    private IndividualType individual;
    private String profileID;
    private List<LoyaltyProgramAccountType> loyaltyProgramAccountList = new ArrayList<LoyaltyProgramAccountType>();
    private FOID FOID;
    private List<IdentityDocumentType> identityDocumentList = new ArrayList<IdentityDocumentType>();
    private String contactInfoRef;
    private String infantRef;
    private List<LanguageUsageType> languageList = new ArrayList<LanguageUsageType>();
    private List<RemarkTypeAIDM> remarkList = new ArrayList<RemarkTypeAIDM>();
    private String passengerID;
    private Boolean profileConsentIndicator;

    /** 
     * Get the 'PTC' element value. Type code applying to the Passenger which typically drives pricing (e.g. ADT, CHD, etc).
     * 
     * @return value
     */
    public String getPTC() {
        return PTC;
    }

    /** 
     * Set the 'PTC' element value. Type code applying to the Passenger which typically drives pricing (e.g. ADT, CHD, etc).
     * 
     * @param PTC
     */
    public void setPTC(String PTC) {
        this.PTC = PTC;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'ResidenceCountryCode' element value. Residence Country Code. Examples: US, FR.
     * 
     * @return value
     */
    public String getResidenceCountryCode() {
        return residenceCountryCode;
    }

    /** 
     * Set the 'ResidenceCountryCode' element value. Residence Country Code. Examples: US, FR.
     * 
     * @param residenceCountryCode
     */
    public void setResidenceCountryCode(String residenceCountryCode) {
        this.residenceCountryCode = residenceCountryCode;
    }

    /** 
     * Get the 'CitizenshipCountryCode' element value. Citizenship Country Code. Examples: US, FR.
     * 
     * @return value
     */
    public String getCitizenshipCountryCode() {
        return citizenshipCountryCode;
    }

    /** 
     * Set the 'CitizenshipCountryCode' element value. Citizenship Country Code. Examples: US, FR.
     * 
     * @param citizenshipCountryCode
     */
    public void setCitizenshipCountryCode(String citizenshipCountryCode) {
        this.citizenshipCountryCode = citizenshipCountryCode;
    }

    /** 
     * Get the 'Individual' element value. A single human being as distinct from a group, class, or family.
     * 
     * @return value
     */
    public IndividualType getIndividual() {
        return individual;
    }

    /** 
     * Set the 'Individual' element value. A single human being as distinct from a group, class, or family.
     * 
     * @param individual
     */
    public void setIndividual(IndividualType individual) {
        this.individual = individual;
    }

    /** 
     * Get the 'ProfileID' element value. Passenger Profile ID
     * 
     * @return value
     */
    public String getProfileID() {
        return profileID;
    }

    /** 
     * Set the 'ProfileID' element value. Passenger Profile ID
     * 
     * @param profileID
     */
    public void setProfileID(String profileID) {
        this.profileID = profileID;
    }

    /** 
     * Get the list of 'LoyaltyProgramAccount' element items. An account set up for a customer within a rewards program which holds funds on behalf of that customer.
     * 
     * @return list
     */
    public List<LoyaltyProgramAccountType> getLoyaltyProgramAccountList() {
        return loyaltyProgramAccountList;
    }

    /** 
     * Set the list of 'LoyaltyProgramAccount' element items. An account set up for a customer within a rewards program which holds funds on behalf of that customer.
     * 
     * @param list
     */
    public void setLoyaltyProgramAccountList(
            List<LoyaltyProgramAccountType> list) {
        loyaltyProgramAccountList = list;
    }

    /** 
     * Get the 'FOID' element value. Form of identification.  Typically used to identify that the passenger is who he says he is.

    This is the type of FOID as defined in AIRIMP (FF Number, Credit Card Number, etc.).

     * 
     * @return value
     */
    public FOID getFOID() {
        return FOID;
    }

    /** 
     * Set the 'FOID' element value. Form of identification.  Typically used to identify that the passenger is who he says he is.

    This is the type of FOID as defined in AIRIMP (FF Number, Credit Card Number, etc.).

     * 
     * @param FOID
     */
    public void setFOID(FOID FOID) {
        this.FOID = FOID;
    }

    /** 
     * Get the list of 'IdentityDocument' element items. Any document which may be used to identify a person or verify aspects of a person's personal identity.
     * 
     * @return list
     */
    public List<IdentityDocumentType> getIdentityDocumentList() {
        return identityDocumentList;
    }

    /** 
     * Set the list of 'IdentityDocument' element items. Any document which may be used to identify a person or verify aspects of a person's personal identity.
     * 
     * @param list
     */
    public void setIdentityDocumentList(List<IdentityDocumentType> list) {
        identityDocumentList = list;
    }

    /** 
     * Get the 'ContactInfoRef' element value. Reference to Contact Information, within the context of one message.
     * 
     * @return value
     */
    public String getContactInfoRef() {
        return contactInfoRef;
    }

    /** 
     * Set the 'ContactInfoRef' element value. Reference to Contact Information, within the context of one message.
     * 
     * @param contactInfoRef
     */
    public void setContactInfoRef(String contactInfoRef) {
        this.contactInfoRef = contactInfoRef;
    }

    /** 
     * Get the 'InfantRef' element value. Reference to Passenger instance within the context of one message, associating an infant on lap to this adult passenger. 
     * 
     * @return value
     */
    public String getInfantRef() {
        return infantRef;
    }

    /** 
     * Set the 'InfantRef' element value. Reference to Passenger instance within the context of one message, associating an infant on lap to this adult passenger. 
     * 
     * @param infantRef
     */
    public void setInfantRef(String infantRef) {
        this.infantRef = infantRef;
    }

    /** 
     * Get the list of 'Language' element items. Language Code representation.
     * 
     * @return list
     */
    public List<LanguageUsageType> getLanguageList() {
        return languageList;
    }

    /** 
     * Set the list of 'Language' element items. Language Code representation.
     * 
     * @param list
     */
    public void setLanguageList(List<LanguageUsageType> list) {
        languageList = list;
    }

    /** 
     * Get the list of 'Remark' element items. Additional, supplementary information about the document or service.
     * 
     * @return list
     */
    public List<RemarkTypeAIDM> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remark' element items. Additional, supplementary information about the document or service.
     * 
     * @param list
     */
    public void setRemarkList(List<RemarkTypeAIDM> list) {
        remarkList = list;
    }

    /** 
     * Get the 'PassengerID' attribute value. Uniquely identifies a Passenger within the context of one message.
     * 
     * @return value
     */
    public String getPassengerID() {
        return passengerID;
    }

    /** 
     * Set the 'PassengerID' attribute value. Uniquely identifies a Passenger within the context of one message.
     * 
     * @param passengerID
     */
    public void setPassengerID(String passengerID) {
        this.passengerID = passengerID;
    }

    /** 
     * Get the 'ProfileConsentIndicator' attribute value. When true, passenger authorizes the airline to share his/her profile information or send promotional emails.
     * 
     * @return value
     */
    public Boolean getProfileConsentIndicator() {
        return profileConsentIndicator;
    }

    /** 
     * Set the 'ProfileConsentIndicator' attribute value. When true, passenger authorizes the airline to share his/her profile information or send promotional emails.
     * 
     * @param profileConsentIndicator
     */
    public void setProfileConsentIndicator(Boolean profileConsentIndicator) {
        this.profileConsentIndicator = profileConsentIndicator;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="MeasureType" name="Age" minOccurs="0"/>
     *   &lt;xs:element type="xs:date" name="Birthdate" minOccurs="0"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int AGE_CHOICE = 0;
        private static final int BIRTHDATE_CHOICE = 1;
        private MeasureType age;
        private LocalDate birthdate;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if Age is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAge() {
            return choiceSelect == AGE_CHOICE;
        }

        /** 
         * Get the 'Age' element value. The Age of the Passenger.  To be used in NDC Anonymous Shopping requests or when the birthdate (in Individual) is not known.
         * 
         * @return value
         */
        public MeasureType getAge() {
            return age;
        }

        /** 
         * Set the 'Age' element value. The Age of the Passenger.  To be used in NDC Anonymous Shopping requests or when the birthdate (in Individual) is not known.
         * 
         * @param age
         */
        public void setAge(MeasureType age) {
            setChoiceSelect(AGE_CHOICE);
            this.age = age;
        }

        /** 
         * Check if Birthdate is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifBirthdate() {
            return choiceSelect == BIRTHDATE_CHOICE;
        }

        /** 
         * Get the 'Birthdate' element value. The Date of Birth of the Passenger.  Anonymous Shopping requests or when the birthdate (in Individual) is not known.
         * 
         * @return value
         */
        public LocalDate getBirthdate() {
            return birthdate;
        }

        /** 
         * Set the 'Birthdate' element value. The Date of Birth of the Passenger.  Anonymous Shopping requests or when the birthdate (in Individual) is not known.
         * 
         * @param birthdate
         */
        public void setBirthdate(LocalDate birthdate) {
            setChoiceSelect(BIRTHDATE_CHOICE);
            this.birthdate = birthdate;
        }
    }
}
