
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * PAYMENT ADDRESS representation.

 Note: This a "relaxed cardinality" representation of Structured Address to support various combinations of Address Verification fields.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentAddrType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Street" minOccurs="0" maxOccurs="2"/>
 *     &lt;xs:element type="xs:string" name="PO_Box" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BuildingRoom" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="City" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="StateProv" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PostalCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Country" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class PaymentAddrType implements Serializable
{
    private List<String> streetList = new ArrayList<String>();
    private String POBox;
    private String buildingRoom;
    private String city;
    private String stateProv;
    private String postalCode;
    private String country;
    private String refs;

    /** 
     * Get the list of 'Street' element items. Street. Examples: Main Street, 100 Main Street
     * 
     * @return list
     */
    public List<String> getStreetList() {
        return streetList;
    }

    /** 
     * Set the list of 'Street' element items. Street. Examples: Main Street, 100 Main Street
     * 
     * @param list
     */
    public void setStreetList(List<String> list) {
        streetList = list;
    }

    /** 
     * Get the 'PO_Box' element value. Post office box. Example: P.O. Box 21
     * 
     * @return value
     */
    public String getPOBox() {
        return POBox;
    }

    /** 
     * Set the 'PO_Box' element value. Post office box. Example: P.O. Box 21
     * 
     * @param POBox
     */
    public void setPOBox(String POBox) {
        this.POBox = POBox;
    }

    /** 
     * Get the 'BuildingRoom' element value. Building name, room, apartment, or suite number.
     * 
     * @return value
     */
    public String getBuildingRoom() {
        return buildingRoom;
    }

    /** 
     * Set the 'BuildingRoom' element value. Building name, room, apartment, or suite number.
     * 
     * @param buildingRoom
     */
    public void setBuildingRoom(String buildingRoom) {
        this.buildingRoom = buildingRoom;
    }

    /** 
     * Get the 'City' element value. City name. Example: Tampa
     * 
     * @return value
     */
    public String getCity() {
        return city;
    }

    /** 
     * Set the 'City' element value. City name. Example: Tampa
     * 
     * @param city
     */
    public void setCity(String city) {
        this.city = city;
    }

    /** 
     * Get the 'StateProv' element value. State or province code or name. Examples: NY, New York
     * 
     * @return value
     */
    public String getStateProv() {
        return stateProv;
    }

    /** 
     * Set the 'StateProv' element value. State or province code or name. Examples: NY, New York
     * 
     * @param stateProv
     */
    public void setStateProv(String stateProv) {
        this.stateProv = stateProv;
    }

    /** 
     * Get the 'PostalCode' element value. Postal code. Examples: 11001, 11001-2345
     * 
     * @return value
     */
    public String getPostalCode() {
        return postalCode;
    }

    /** 
     * Set the 'PostalCode' element value. Postal code. Examples: 11001, 11001-2345
     * 
     * @param postalCode
     */
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    /** 
     * Get the 'Country' element value. Country name or code.
    Examples: US, United States

    Encoding Scheme: ISO 3166-1 (two character) Country Code
     * 
     * @return value
     */
    public String getCountry() {
        return country;
    }

    /** 
     * Set the 'Country' element value. Country name or code.
    Examples: US, United States

    Encoding Scheme: ISO 3166-1 (two character) Country Code
     * 
     * @param country
     */
    public void setCountry(String country) {
        this.country = country;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
