
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * Payment Processing Rules Notice definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentRulesNoticeType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="TrxProcessObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="FormOfPayment" minOccurs="0">
 *           &lt;!-- Reference to inner class FormOfPayment -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentRulesNoticeType extends TrxProcessObjectBaseType implements
    Serializable
{
    private FormOfPayment formOfPayment;

    /** 
     * Get the 'FormOfPayment' element value.
     * 
     * @return value
     */
    public FormOfPayment getFormOfPayment() {
        return formOfPayment;
    }

    /** 
     * Set the 'FormOfPayment' element value.
     * 
     * @param formOfPayment
     */
    public void setFormOfPayment(FormOfPayment formOfPayment) {
        this.formOfPayment = formOfPayment;
    }
    /** 
     * Form of Payment Failure Rules. Rule Application Scope: 1. Order ID (entire order) 2. Order Item ID (e.g. flights and ancillary services)
                
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FormOfPayment" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element name="Query">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:boolean" use="optional" name="ProceedOnFailureInd"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="Results">
     *         &lt;!-- Reference to inner class Results -->
     *       &lt;/xs:element>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FormOfPayment implements Serializable
    {
        private int formOfPaymentSelect = -1;
        private static final int QUERY_CHOICE = 0;
        private static final int RESULTS_CHOICE = 1;
        private Boolean query;
        private Results results;

        private void setFormOfPaymentSelect(int choice) {
            if (formOfPaymentSelect == -1) {
                formOfPaymentSelect = choice;
            } else if (formOfPaymentSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearFormOfPaymentSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearFormOfPaymentSelect() {
            formOfPaymentSelect = -1;
        }

        /** 
         * Check if Query is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifQuery() {
            return formOfPaymentSelect == QUERY_CHOICE;
        }

        /** 
         * Get the 'ProceedOnFailureInd' attribute value. When true, the Seller wants to proceed with Order creation if one of multiple forms of payment provided fails. Note: This supports multi payment form-enabled systems where one Traveler may provide multiple FOPs, or individual Travelers may each provide their own FOP.
                            
         * 
         * @return value
         */
        public Boolean getQuery() {
            return query;
        }

        /** 
         * Set the 'ProceedOnFailureInd' attribute value. When true, the Seller wants to proceed with Order creation if one of multiple forms of payment provided fails. Note: This supports multi payment form-enabled systems where one Traveler may provide multiple FOPs, or individual Travelers may each provide their own FOP.
                            
         * 
         * @param query
         */
        public void setQuery(Boolean query) {
            setFormOfPaymentSelect(QUERY_CHOICE);
            this.query = query;
        }

        /** 
         * Check if Results is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifResults() {
            return formOfPaymentSelect == RESULTS_CHOICE;
        }

        /** 
         * Get the 'Results' element value.
         * 
         * @return value
         */
        public Results getResults() {
            return results;
        }

        /** 
         * Set the 'Results' element value.
         * 
         * @param results
         */
        public void setResults(Results results) {
            setFormOfPaymentSelect(RESULTS_CHOICE);
            this.results = results;
        }
        /** 
         * Payment Order Creation Rule Usage during transaction processing.
                        
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Results">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="Code" minOccurs="0"/>
         *       &lt;xs:element ref="Associations"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="PaymentFailureInd"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Results implements Serializable
        {
            private String code;
            private Associations associations;
            private Boolean paymentFailureInd;

            /** 
             * Get the 'Code' element value. 
                                  Payment Failure Code (and optional definition.) Encoding Scheme: IATA Padis Codeset - List for data element [9321] Application Error, coded
                                
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' element value. 
                                  Payment Failure Code (and optional definition.) Encoding Scheme: IATA Padis Codeset - List for data element [9321] Application Error, coded
                                
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }

            /** 
             * Get the 'Associations' element value.
             * 
             * @return value
             */
            public Associations getAssociations() {
                return associations;
            }

            /** 
             * Set the 'Associations' element value.
             * 
             * @param associations
             */
            public void setAssociations(Associations associations) {
                this.associations = associations;
            }

            /** 
             * Get the 'PaymentFailureInd' attribute value. 
                                When true, one of multiple forms of payment provided failed.
                              
             * 
             * @return value
             */
            public Boolean getPaymentFailureInd() {
                return paymentFailureInd;
            }

            /** 
             * Set the 'PaymentFailureInd' attribute value. 
                                When true, one of multiple forms of payment provided failed.
                              
             * 
             * @param paymentFailureInd
             */
            public void setPaymentFailureInd(Boolean paymentFailureInd) {
                this.paymentFailureInd = paymentFailureInd;
            }
        }
    }
}
