
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Policy information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Policies">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Policy" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class Policy -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Policies implements Serializable
{
    private List<Policy> policyList = new ArrayList<Policy>();

    /** 
     * Get the list of 'Policy' element items.
     * 
     * @return list
     */
    public List<Policy> getPolicyList() {
        return policyList;
    }

    /** 
     * Set the list of 'Policy' element items.
     * 
     * @param list
     */
    public void setPolicyList(List<Policy> list) {
        policyList = list;
    }
    /** 
     * Policy detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Policy" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="PolicyType">
     *         &lt;xs:sequence>
     *           &lt;xs:element ref="DefaultPolicy"/>
     *           &lt;xs:element ref="PolicyAugmentation"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Policy extends PolicyType implements Serializable
    {
        private PolicyDefaultType defaultPolicy;
        private PolicyAugmentationType policyAugmentation;

        /** 
         * Get the 'DefaultPolicy' element value.
         * 
         * @return value
         */
        public PolicyDefaultType getDefaultPolicy() {
            return defaultPolicy;
        }

        /** 
         * Set the 'DefaultPolicy' element value.
         * 
         * @param defaultPolicy
         */
        public void setDefaultPolicy(PolicyDefaultType defaultPolicy) {
            this.defaultPolicy = defaultPolicy;
        }

        /** 
         * Get the 'PolicyAugmentation' element value.
         * 
         * @return value
         */
        public PolicyAugmentationType getPolicyAugmentation() {
            return policyAugmentation;
        }

        /** 
         * Set the 'PolicyAugmentation' element value.
         * 
         * @param policyAugmentation
         */
        public void setPolicyAugmentation(
                PolicyAugmentationType policyAugmentation) {
            this.policyAugmentation = policyAugmentation;
        }
    }
}
