
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type definition for Policy.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PolicyType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="CoreBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Nodes">
 *           &lt;xs:complexType>
 *             &lt;xs:sequence>
 *               &lt;xs:element type="NodePathType" name="Node" maxOccurs="unbounded"/>
 *             &lt;/xs:sequence>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element name="Descriptions" minOccurs="0">
 *           &lt;!-- Reference to inner class Descriptions -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Metadata" minOccurs="0">
 *           &lt;!-- Reference to inner class Metadata -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="xs:string" use="required" name="PolicyType"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="Version"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PolicyType extends CoreBaseType implements Serializable
{
    private List<NodePathType> nodeList = new ArrayList<NodePathType>();
    private Descriptions descriptions;
    private Metadata metadata;
    private String policyType;
    private String version;

    /** 
     * Get the list of 'Node' element items. Policy Data Node information.

    Note: Describes schema document node location, including node tag name and path, for data with associated policy.
     * 
     * @return list
     */
    public List<NodePathType> getNodeList() {
        return nodeList;
    }

    /** 
     * Set the list of 'Node' element items. Policy Data Node information.

    Note: Describes schema document node location, including node tag name and path, for data with associated policy.
     * 
     * @param list
     */
    public void setNodeList(List<NodePathType> list) {
        nodeList = list;
    }

    /** 
     * Get the 'Descriptions' element value.
     * 
     * @return value
     */
    public Descriptions getDescriptions() {
        return descriptions;
    }

    /** 
     * Set the 'Descriptions' element value.
     * 
     * @param descriptions
     */
    public void setDescriptions(Descriptions descriptions) {
        this.descriptions = descriptions;
    }

    /** 
     * Get the 'Metadata' element value.
     * 
     * @return value
     */
    public Metadata getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value.
     * 
     * @param metadata
     */
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    /** 
     * Get the 'PolicyType' attribute value. Policy Type. Examples: Privacy_PII, Payment_PCI, Credentialing

    Note: Supports pre-defined enumerated list and/ or bilaterally-agreed upon values.
     * 
     * @return value
     */
    public String getPolicyType() {
        return policyType;
    }

    /** 
     * Set the 'PolicyType' attribute value. Policy Type. Examples: Privacy_PII, Payment_PCI, Credentialing

    Note: Supports pre-defined enumerated list and/ or bilaterally-agreed upon values.
     * 
     * @param policyType
     */
    public void setPolicyType(String policyType) {
        this.policyType = policyType;
    }

    /** 
     * Get the 'Version' attribute value. Policy Version. Example: 2.17
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value. Policy Version. Example: 2.17
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Policy Description, including text and link.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Descriptions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="LinkDescriptionType" name="Description" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Descriptions implements Serializable
    {
        private List<LinkDescriptionType> descriptionList = new ArrayList<LinkDescriptionType>();

        /** 
         * Get the list of 'Description' element items. Policy Description, including text and link.
         * 
         * @return list
         */
        public List<LinkDescriptionType> getDescriptionList() {
            return descriptionList;
        }

        /** 
         * Set the list of 'Description' element items. Policy Description, including text and link.
         * 
         * @param list
         */
        public void setDescriptionList(List<LinkDescriptionType> list) {
            descriptionList = list;
        }
    }
    /** 
     * Policy Metadata, including policy effective period.

    Note: Information and/ or capabilities specified in Metadata may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation is not dictated by this specification.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Metadata" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="MetaBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="RemarkType" name="Remarks" minOccurs="0" maxOccurs="unbounded"/>
     *           &lt;xs:element type="EncSchemeType" name="EncodingScheme" minOccurs="0"/>
     *           &lt;xs:element type="CorePeriodGrpType" name="ValidPeriod" minOccurs="0" maxOccurs="unbounded"/>
     *         &lt;/xs:sequence>
     *         &lt;xs:attribute type="xs:string" use="optional" name="PolicyCode"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Metadata extends MetaBaseType implements Serializable
    {
        private List<RemarkType> remarkList = new ArrayList<RemarkType>();
        private EncSchemeType encodingScheme;
        private List<CorePeriodGrpType> validPeriodList = new ArrayList<CorePeriodGrpType>();
        private String policyCode;

        /** 
         * Get the list of 'Remarks' element items. Remark(s).
         * 
         * @return list
         */
        public List<RemarkType> getRemarkList() {
            return remarkList;
        }

        /** 
         * Set the list of 'Remarks' element items. Remark(s).
         * 
         * @param list
         */
        public void setRemarkList(List<RemarkType> list) {
            remarkList = list;
        }

        /** 
         * Get the 'EncodingScheme' element value. Encoding Scheme information.
         * 
         * @return value
         */
        public EncSchemeType getEncodingScheme() {
            return encodingScheme;
        }

        /** 
         * Set the 'EncodingScheme' element value. Encoding Scheme information.
         * 
         * @param encodingScheme
         */
        public void setEncodingScheme(EncSchemeType encodingScheme) {
            this.encodingScheme = encodingScheme;
        }

        /** 
         * Get the list of 'ValidPeriod' element items. Policy Effective and Expiration Period.
         * 
         * @return list
         */
        public List<CorePeriodGrpType> getValidPeriodList() {
            return validPeriodList;
        }

        /** 
         * Set the list of 'ValidPeriod' element items. Policy Effective and Expiration Period.
         * 
         * @param list
         */
        public void setValidPeriodList(List<CorePeriodGrpType> list) {
            validPeriodList = list;
        }

        /** 
         * Get the 'PolicyCode' attribute value. Policy Code or ID. Example: DATA1
         * 
         * @return value
         */
        public String getPolicyCode() {
            return policyCode;
        }

        /** 
         * Set the 'PolicyCode' attribute value. Policy Code or ID. Example: DATA1
         * 
         * @param policyCode
         */
        public void setPolicyCode(String policyCode) {
            this.policyCode = policyCode;
        }
    }
}
